/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.service.impl;

import com.aliyun.openservices.shade.org.apache.commons.lang3.Validate;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.rocketmq.service.RocketMqProducer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.mn.third.system.dataphin.sdk.service.DataPhinZmsd121Service;
import com.biz.crm.mn.third.system.dataphin.sdk.service.DataPhinZmsd187Service;
import com.biz.crm.tpm.business.third.system.local.service.PullFeePoolDataService;
import com.biz.crm.tpm.business.third.system.sdk.constants.FeePoolConstant;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd121Service;
import com.biz.crm.tpm.business.third.system.sdk.service.Zmsd187Service;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class PullFeePoolDataServiceImpl
implements PullFeePoolDataService {
    private static final Logger log = LoggerFactory.getLogger(PullFeePoolDataServiceImpl.class);
    @Autowired(required=false)
    private DataPhinZmsd187Service dataPhinZmsd187Service;
    @Autowired(required=false)
    private DataPhinZmsd121Service dataPhinZmsd121Service;
    @Autowired(required=false)
    private Zmsd187Service zmsd187Service;
    @Autowired(required=false)
    private Zmsd121Service zmsd121Service;
    @Autowired(required=false)
    private RocketMqProducer rocketMqProducer;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private RedisLockService redisLockService;

    @Override
    @Async
    public void pullFeePoolDataAsync(String ds, String accountingPeriod, AbstractCrmUserIdentity userIdentity) {
        this.loginUserService.refreshAuthentication((Object)userIdentity);
        this.pullFeePoolData(ds, accountingPeriod);
    }

    @Override
    public void pullFeePoolData(String ds, String accountingPeriod) {
        String lockKey = "pull:fee_pool_data:lock";
        boolean hasLock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 6L);
        Validate.isTrue((boolean)hasLock, (String)"\u6b63\u5728\u62c9\u53d6\u6570\u636e\uff0c\u8bf7\u7a0d\u540e", (Object[])new Object[0]);
        try {
            int i;
            Integer size = FeePoolConstant.PAGE_SIZE;
            Integer total = this.dataPhinZmsd187Service.getZmsd187DataTotal(ds, accountingPeriod);
            int page = total / size;
            page = total % size == 0 ? page : page + 1;
            log.info("\u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e187 \u5171{}\u6761\u6570\u636e, \u9700\u8c03\u7528{}\u6b21, \u6bcf\u6b21\u83b7\u53d6{}\u6761\u6570\u636e", new Object[]{total, page, size});
            this.zmsd187Service.deleteByDs(ds);
            for (i = 0; i < page; ++i) {
                try {
                    List zmsd187VoList = this.dataPhinZmsd187Service.getZmsd187Data(ds, accountingPeriod, Integer.valueOf(i), size);
                    this.zmsd187Service.saveEntityBatch(ds, zmsd187VoList);
                    log.info("\u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e187 \u7b2c{} \u6279\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01", (Object)i);
                    continue;
                }
                catch (Exception e) {
                    log.error("\u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e187 \u7b2c{} \u6279\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01" + e.getMessage(), (Object)i);
                }
            }
            total = this.dataPhinZmsd121Service.getZmsd121DataTotal(ds, accountingPeriod);
            page = total / size;
            page = total % size == 0 ? page : page + 1;
            log.info("\u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e121 \u5171{}\u6761\u6570\u636e, \u9700\u8c03\u7528{}\u6b21, \u6bcf\u6b21\u83b7\u53d6{}\u6761\u6570\u636e", new Object[]{total, page, size});
            this.zmsd121Service.deleteByDs(ds);
            for (int j = 0; j < page; ++j) {
                try {
                    List zmsd121VoList = this.dataPhinZmsd121Service.getZmsd121Data(ds, accountingPeriod, Integer.valueOf(j), size);
                    this.zmsd121Service.saveEntityBatch(ds, zmsd121VoList);
                    log.info("\u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e121 \u7b2c{} \u6279\u6570\u636e\u4fdd\u5b58\u6210\u529f\uff01", (Object)(i + j));
                    continue;
                }
                catch (Exception e) {
                    log.error("\u8d39\u7528\u6c60\u4f59\u989d\u81ea\u52a8\u540c\u6b65\u6570\u636e121 \u7b2c{} \u6279\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01" + e.getMessage(), (Object)j);
                }
            }
            MqMessageVo mqMessage = new MqMessageVo();
            mqMessage.setTopic("TPM_WITHHOLDING_DETAIL_TOPIC" + RocketMqUtil.mqEnvironment());
            mqMessage.setMsgBody(ds);
            mqMessage.setTag("WITHHOLDING_DETAIL_FEE_POOL_TAG");
            this.rocketMqProducer.sendMqOrderMsg(mqMessage, ds, 10L);
        }
        catch (Exception e) {
            log.error("\u8d39\u7528\u6c60\u62c9\u53d6\u65f6\u62a5\u9519{}", (Object)e.getMessage());
            log.error("", (Throwable)e);
            throw e;
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
    }
}

