/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.third.system.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.aliyun.openservices.shade.com.google.common.collect.Maps;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.model.AbstractCrmUserIdentity;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.business.common.sdk.service.RedisService;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgSubComOrgService;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgSubComOrgVo;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.util.UuidCrmUtil;
import com.biz.crm.mn.third.system.dataphin.sdk.DataphinService;
import com.biz.crm.mn.third.system.dataphin.sdk.vo.ProfitabilityAnalysisVo;
import com.biz.crm.tpm.business.third.system.local.entity.TpmProfitabilityAnalysis;
import com.biz.crm.tpm.business.third.system.local.repository.TpmProfitabilityAnalysisRepository;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmProfitabilityAnalysisDto;
import com.biz.crm.tpm.business.third.system.sdk.dto.TpmZtfi099ForEctQueryDto;
import com.biz.crm.tpm.business.third.system.sdk.service.TpmProfitabilityAnalysisService;
import com.biz.crm.tpm.business.third.system.sdk.vo.TpmProfitabilityAnalysisVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service(value="tpmProfitabilityAnalysisService")
public class TpmProfitabilityAnalysisServiceImpl
implements TpmProfitabilityAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(TpmProfitabilityAnalysisServiceImpl.class);
    @Autowired(required=false)
    private TpmProfitabilityAnalysisRepository tpmProfitabilityAnalysisRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private DataphinService dataphinService;
    @Autowired(required=false)
    private DictToolkitService dictToolkitService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private RedisLockService redisLockService;
    @Autowired(required=false)
    private SalesOrgSubComOrgService salesOrgSubComOrgService;
    @Autowired(required=false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required=false)
    private CustomerVoService customerVoService;
    @Autowired(required=false)
    private RedisService redisService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void pull099ByYearMonth(String yearMonth, String companyCode, String accountDate) {
        Assert.hasLength((String)yearMonth, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        if (yearMonth.contains("-")) {
            yearMonth = yearMonth.replace("-", "");
        }
        if (StringUtils.isNotEmpty((CharSequence)accountDate) && accountDate.contains("-")) {
            accountDate = accountDate.replace("-", "");
        }
        Assert.isTrue((yearMonth.length() == 6 ? 1 : 0) != 0, (String)"\u5e74\u6708\u683c\u5f0f\u4e0d\u5408\u6cd5![yyyyMM]");
        String ds = yearMonth + "02";
        String lockKey = "pull_bjx099_data:lock:" + yearMonth;
        String successKey = "pull_bjx099_data:flag:" + yearMonth;
        Object successFlag = this.redisService.get(successKey);
        if (Objects.nonNull(successFlag) && BooleanEnum.TRUE.getCapital().equals(successFlag.toString())) {
            log.info("099\u62a5\u8868\u62c9\u53d6\u6570\u636eds\u5206\u533a[{}]yearMonth[{}]companyCode[{}]accountDate[{}]\u672c\u6b21\u5ffd\u7565,\u4e0a\u6b21\u5df2\u6210\u529f!", new Object[]{ds, yearMonth, companyCode, accountDate});
            return;
        }
        boolean lock = this.redisLockService.tryLock(lockKey, TimeUnit.HOURS, 5L);
        Assert.isTrue((boolean)lock, (String)("\u4e0a\u6b21\u62c9\u53d6\u3010" + yearMonth + "\u3011\u6708\u5c1a\u672a\u5b8c\u6210"));
        try {
            Integer total = this.doExecuteZtfi099ByMonth(ds, yearMonth, companyCode, accountDate);
            if (Objects.nonNull(total) && total > 0 && StringUtil.isEmpty((CharSequence)companyCode) && StringUtil.isEmpty((CharSequence)accountDate)) {
                this.redisService.set(successKey, (Object)BooleanEnum.TRUE.getCapital(), 604800L);
            }
            log.info("099\u62a5\u8868\u62c9\u53d6\u6570\u636eds\u5206\u533a[{}]yearMonth[{}]companyCode[{}]accountDate[{}]\u6210\u529f!", new Object[]{ds, yearMonth, companyCode, accountDate});
        }
        finally {
            this.redisLockService.unlock(lockKey);
        }
    }

    @Async
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.NOT_SUPPORTED)
    public void handPull099ByYearMonthAsync(String yearMonth, String companyCode, String accountDate) {
        Assert.hasLength((String)yearMonth, (String)"\u5e74\u6708\u4e0d\u80fd\u4e3a\u7a7a");
        this.loginUserService.refreshAuthentication(null);
        this.pull099ByYearMonth(yearMonth, companyCode, accountDate);
    }

    private Integer doExecuteZtfi099ByMonth(String ds, String yearMonth, String companyCode, String accountDate) {
        String lastYearMonth = DateUtil.format((Date)DateUtil.formatAddMonth((Date)DateUtil.parse((String)yearMonth, (String)"yyyyMM"), (int)-1), (String)"yyyyMM");
        log.info("099\u62a5\u8868\u62c9\u53d6\u6570\u636eds\u5206\u533a\u5220\u9664\u6570\u636e[{}]yearMonthLy[{}]companyCode[{}]accountDate[{}]", new Object[]{ds, lastYearMonth, companyCode, accountDate});
        this.tpmProfitabilityAnalysisRepository.removeByQuery(ds, lastYearMonth, companyCode, accountDate);
        Integer total = this.dataphinService.getZtfi099Total(ds, companyCode, accountDate);
        log.info("099\u62a5\u8868\u62c9\u53d6\u6570\u636eds\u5206\u533a[{}]\u603b\u6570[{}]", (Object)ds, (Object)total);
        String tenantCode = TenantUtils.getTenantCode();
        Date nowTime = new Date();
        if (total > 0) {
            AbstractCrmUserIdentity loginUser = this.loginUserService.getAbstractLoginUser();
            int pageSize = 1000;
            int pageNumber = total / pageSize;
            int startPageNum = 0;
            int endPageNum = 19;
            do {
                if (startPageNum > endPageNum) {
                    return total;
                }
                try {
                    log.info("099\u62a5\u8868\u62c9\u53d6\u6570\u636eds\u5206\u533a[{}][\u5f00\u59cb\u9875[{}]\u7ed3\u675f\u9875[{}]\u603b\u9875[{}]\u5269\u4f59\u9875[{}]", new Object[]{ds, startPageNum, endPageNum, pageNumber, pageNumber - endPageNum - 1});
                    List data = this.dataphinService.getZtfi099Data(ds, companyCode, accountDate, startPageNum, endPageNum, pageSize);
                    Collection list = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)data, ProfitabilityAnalysisVo.class, TpmProfitabilityAnalysis.class, HashSet.class, ArrayList.class, new String[0]);
                    List materialCodes = list.stream().filter(item -> CharSequenceUtil.isNotEmpty((CharSequence)item.getMaterialCode())).map(o -> o.getMaterialCode().substring(6)).distinct().collect(Collectors.toList());
                    List productVoList = this.productVoService.findByProductCodes(materialCodes);
                    Map productMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity(), (newValue, oldValue) -> newValue));
                    Map<Object, Object> salesOrgSubComOrgMap = Maps.newHashMap();
                    List salesOrgCodes = list.stream().map(TpmProfitabilityAnalysis::getSalesOrgCode).distinct().collect(Collectors.toList());
                    List salesOrgList = this.salesOrgSubComOrgService.listBySalesOrgCodeList(salesOrgCodes, BusinessFormatEnum.NORMAL.getCode());
                    if (CollectionUtils.isNotEmpty((Collection)salesOrgList)) {
                        salesOrgSubComOrgMap = salesOrgList.stream().collect(Collectors.toMap(SalesOrgSubComOrgVo::getSalesOrgCode, Function.identity(), (v1, v2) -> v2));
                    }
                    for (TpmProfitabilityAnalysis pro : list) {
                        SalesOrgSubComOrgVo salesOrgSubComOrgVo;
                        if (!CollectionUtil.isNotEmpty((Map)salesOrgSubComOrgMap) || !Objects.nonNull(salesOrgSubComOrgVo = (SalesOrgSubComOrgVo)salesOrgSubComOrgMap.get(pro.getSalesOrgCode()))) continue;
                        pro.setOrgCode(salesOrgSubComOrgVo.getOrgCode());
                        pro.setOrgName(salesOrgSubComOrgVo.getOrgName());
                    }
                    list.forEach(o -> {
                        String materialCode;
                        ProductVo productVo;
                        o.setId(UuidCrmUtil.general());
                        o.setTenantCode(tenantCode);
                        o.setYearMonthLy(o.getAccountDate().substring(0, 6));
                        o.setCreateName(loginUser.getRealName());
                        o.setCreateAccount(loginUser.getAccount());
                        o.setCreateTime(nowTime);
                        o.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        o.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
                        o.setCustomerCode(o.getDealerCode() + o.getSalesOrgCode() + o.getChannelCode() + o.getSpartCode());
                        o.setSalesInstitutionErpCode(o.getSalesOrgCode());
                        o.setSalesInstitutionCode(o.getChannelCode() + o.getSpartCode() + o.getSalesOrgCode());
                        o.setSalesOrgCode("");
                        if (o.getMaterialCode().startsWith("000000")) {
                            o.setMaterialCode(o.getMaterialCode().substring(6));
                        }
                        if ((productVo = (ProductVo)productMap.get(materialCode = o.getMaterialCode())) != null) {
                            o.setCategoryCode(productVo.getProductCategoryCode());
                            o.setCategoryName(productVo.getProductCategoryName());
                            o.setItemCode(productVo.getProductLevelCode());
                            o.setItemName(productVo.getProductLevelName());
                        }
                    });
                    this.setExtandInfo(list);
                    this.tpmProfitabilityAnalysisRepository.batchSave(list);
                    if (pageNumber <= endPageNum) {
                        return total;
                    }
                    startPageNum = endPageNum + 1;
                    if (pageNumber >= (endPageNum += 10)) continue;
                    endPageNum = pageNumber;
                }
                catch (Exception e) {
                    log.info("099\u62a5\u8868\u62c9\u53d6\u6570\u636eds\u5206\u533a[{}] \u5f02\u5e38\n{}", (Object)ds, (Object)e.getMessage());
                    log.error("", (Throwable)e);
                    throw e;
                }
            } while (endPageNum <= pageNumber);
        }
        return total;
    }

    private void setExtandInfo(Collection<TpmProfitabilityAnalysis> list) {
        Map salesOrgMap;
        List customerVos;
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        List salesInstitutionCodeList = list.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getSalesInstitutionCode())).map(TpmProfitabilityAnalysis::getSalesInstitutionCode).distinct().collect(Collectors.toList());
        List customerCodeList = list.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getCustomerCode())).map(TpmProfitabilityAnalysis::getCustomerCode).distinct().collect(Collectors.toList());
        HashMap customerVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(customerCodeList) && CollectionUtil.isNotEmpty((Collection)(customerVos = this.customerVoService.findByCustomerCodes(customerCodeList)))) {
            customerVoMap.putAll(customerVos.stream().collect(Collectors.toMap(CustomerVo::getCustomerCode, v -> v, (n, o) -> n)));
        }
        HashMap salesOrgVoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty(salesInstitutionCodeList) && CollectionUtil.isNotEmpty((Map)(salesOrgMap = this.salesOrgVoService.getSalesMapByTpmCodes(salesInstitutionCodeList)))) {
            salesOrgVoMap.putAll(salesOrgMap);
        }
        for (TpmProfitabilityAnalysis entity : list) {
            CustomerVo customerVo;
            SalesOrgVo salesOrgVo;
            if (StringUtils.isNotEmpty((CharSequence)entity.getSalesInstitutionCode()) && null != (salesOrgVo = (SalesOrgVo)salesOrgVoMap.get(entity.getSalesInstitutionCode()))) {
                entity.setSalesInstitutionName(salesOrgVo.getSalesOrgName());
            }
            if (!StringUtils.isNotEmpty((CharSequence)entity.getCustomerCode()) || null == (customerVo = (CustomerVo)customerVoMap.get(entity.getCustomerCode()))) continue;
            entity.setSalesRegionName(customerVo.getSalesRegionName());
            entity.setSalesRegionCode(customerVo.getSalesRegionCode());
            entity.setSalesRegionErpCode(customerVo.getSalesRegionErpCode());
            entity.setSalesOrgName(customerVo.getSalesOrgName());
            entity.setSalesOrgCode(customerVo.getSalesOrgCode());
            entity.setSalesOrgErpCode(customerVo.getSalesOrgErpCode());
        }
    }

    public List<TpmProfitabilityAnalysisVo> listForVariable(TpmProfitabilityAnalysisDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getChannelCode())) {
            Map map = this.dictToolkitService.findMapByDictTypeCode("mdm_channel_r_sap");
            dto.setChannelCode(map.getOrDefault(dto.getChannelCode(), dto.getChannelCode()));
        }
        return this.tpmProfitabilityAnalysisRepository.listForVariable(dto);
    }

    public Page<TpmProfitabilityAnalysisVo> findData4Ect(Pageable pageable, TpmZtfi099ForEctQueryDto ectZtfi099QueryDto) {
        return this.tpmProfitabilityAnalysisRepository.findData4Ect(pageable, ectZtfi099QueryDto);
    }

    public List<TpmProfitabilityAnalysisVo> findDataSummaryByProfitMonitor(List<TpmProfitabilityAnalysisDto> analysisDtos) {
        return this.tpmProfitabilityAnalysisRepository.findDataSummaryByProfitMonitor(analysisDtos);
    }

    public BigDecimal computeAmountForProductMergeSaleAmount(TpmProfitabilityAnalysisDto dto) {
        if (Objects.isNull(dto)) {
            return BigDecimal.ZERO;
        }
        return this.tpmProfitabilityAnalysisRepository.computeAmountForProductMergeSaleAmount(dto);
    }
}

