/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.account.reconciliation.factor.local.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.tpm.business.account.reconciliation.factor.local.entity.TpmAccountReconciliationFactorEntity;
import com.biz.crm.tpm.business.account.reconciliation.factor.local.entity.TpmAccountReconciliationFactorLogEntity;
import com.biz.crm.tpm.business.account.reconciliation.factor.local.mapper.TpmAccountReconciliationFactorEntityMapper;
import com.biz.crm.tpm.business.account.reconciliation.factor.local.mapper.TpmAccountReconciliationFactorLogEntityMapper;
import com.biz.crm.tpm.business.account.reconciliation.factor.local.repository.TpmAccountReconciliationFactorEntityRepository;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.constant.ModalTypeEnum;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.dto.TpmAccountReconciliationFactorDto;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.dto.TpmAccountReconciliationFactorLogDto;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.event.TpmAccountReconciliationFactorLogEventListener;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.service.TpmAccountReconciliationFactorService;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorColumnConfigVo;
import com.biz.crm.tpm.business.account.reconciliation.factor.sdk.vo.TpmAccountReconciliationFactorRespVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class TpmAccountReconciliationFactorServiceImpl
implements TpmAccountReconciliationFactorService {
    private static final Logger log = LoggerFactory.getLogger(TpmAccountReconciliationFactorServiceImpl.class);
    @Autowired(required=false)
    GenerateCodeService generateCodeService;
    @Autowired(required=false)
    NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private TpmAccountReconciliationFactorEntityMapper tpmAccountReconciliationFactorEntityMapper;
    @Autowired(required=false)
    private TpmAccountReconciliationFactorEntityRepository tpmAccountReconciliationFactorEntityRepository;
    @Autowired(required=false)
    private TpmAccountReconciliationFactorLogEntityMapper tpmAccountReconciliationFactorLogEntityMapper;
    @Autowired(required=false)
    private TpmAccountReconciliationFactorLogEventListener tpmAccountReconciliationFactorLogEventListener;

    public Page<TpmAccountReconciliationFactorRespVo> findByConditions(TpmAccountReconciliationFactorDto reqVo, Pageable pageable) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull(reqVo)) {
            reqVo = new TpmAccountReconciliationFactorDto();
        }
        reqVo.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.tpmAccountReconciliationFactorEntityMapper.findByConditions((Page<TpmAccountReconciliationFactorRespVo>)page, reqVo);
    }

    public TpmAccountReconciliationFactorRespVo findById(String id) {
        TpmAccountReconciliationFactorEntity entity = this.tpmAccountReconciliationFactorEntityMapper.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (entity != null) {
            TpmAccountReconciliationFactorRespVo reconciliationFactorRespVo = (TpmAccountReconciliationFactorRespVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmAccountReconciliationFactorRespVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
            if (ModalTypeEnum.DETAIL.getCode().equals(entity.getComponentName()) || ModalTypeEnum.SUMMARY.getCode().equals(entity.getComponentName()) || ModalTypeEnum.TAIL.getCode().equals(entity.getComponentName())) {
                reconciliationFactorRespVo.setFactorConfigList(JSONArray.parseArray((String)entity.getFactorConfig(), TpmAccountReconciliationFactorColumnConfigVo.class));
            }
            return reconciliationFactorRespVo;
        }
        throw new UnsupportedOperationException("\u672a\u627e\u5230\u8be6\u60c5\u6570\u636e");
    }

    public List<TpmAccountReconciliationFactorRespVo> findByCodes(Set<String> codes) {
        if (CollectionUtils.isEmpty(codes)) {
            return Lists.newArrayList();
        }
        List<TpmAccountReconciliationFactorEntity> reconciliationFactorEntities = this.tpmAccountReconciliationFactorEntityRepository.findByCodes(codes);
        if (CollectionUtils.isEmpty(reconciliationFactorEntities)) {
            return Lists.newArrayList();
        }
        ArrayList tpmAccountReconciliationFactorRespVos = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(reconciliationFactorEntities, TpmAccountReconciliationFactorEntity.class, TpmAccountReconciliationFactorRespVo.class, HashSet.class, ArrayList.class, new String[0]));
        tpmAccountReconciliationFactorRespVos.forEach(factorRespVo -> {
            if (JSONUtil.isTypeJSONArray((String)factorRespVo.getFactorConfig())) {
                factorRespVo.setFactorConfigList(JSONArray.parseArray((String)factorRespVo.getFactorConfig(), TpmAccountReconciliationFactorColumnConfigVo.class));
            }
        });
        return tpmAccountReconciliationFactorRespVos;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmAccountReconciliationFactorRespVo create(TpmAccountReconciliationFactorDto reqVo) {
        if (!reqVo.validate()) {
            throw new UnsupportedOperationException("\u7f3a\u5c11\u5fc5\u8981\u6570\u636e");
        }
        reqVo.setTenantCode(TenantUtils.getTenantCode());
        TpmAccountReconciliationFactorEntity entity = (TpmAccountReconciliationFactorEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reqVo, TpmAccountReconciliationFactorEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        String ruleCode = "DZYS";
        entity.setAccountReconciliationFactorCode((String)this.generateCodeService.generateCode(ruleCode, 1).get(0));
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        this.tpmAccountReconciliationFactorEntityMapper.insert((Object)entity);
        TpmAccountReconciliationFactorLogDto logDto = new TpmAccountReconciliationFactorLogDto();
        logDto.setNewest(reqVo);
        this.tpmAccountReconciliationFactorLogEventListener.onCreate(logDto);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public TpmAccountReconciliationFactorRespVo edit(TpmAccountReconciliationFactorDto reqVo) {
        TpmAccountReconciliationFactorEntity original;
        if (StringUtils.isNotEmpty((CharSequence)reqVo.getId()) && reqVo.validate()) {
            reqVo.setTenantCode(TenantUtils.getTenantCode());
            original = this.tpmAccountReconciliationFactorEntityMapper.findByIdAndTenantCode(reqVo.getId(), TenantUtils.getTenantCode());
            if (original == null) {
                throw new UnsupportedOperationException("\u672a\u67e5\u8be2\u5230\u5bf9\u8d26\u8981\u7d20\u6570\u636e");
            }
        } else {
            throw new UnsupportedOperationException("\u7f3a\u5c11\u5fc5\u8981\u6570\u636e");
        }
        TpmAccountReconciliationFactorEntity entity = (TpmAccountReconciliationFactorEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reqVo, TpmAccountReconciliationFactorEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmAccountReconciliationFactorEntityMapper.updateById((Object)entity);
        TpmAccountReconciliationFactorLogDto logDto = new TpmAccountReconciliationFactorLogDto();
        logDto.setNewest(reqVo);
        logDto.setOriginal((TpmAccountReconciliationFactorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)original, TpmAccountReconciliationFactorDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        this.tpmAccountReconciliationFactorLogEventListener.onUpdate(logDto);
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void delete(List<String> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            List<TpmAccountReconciliationFactorEntity> entityList = this.tpmAccountReconciliationFactorEntityMapper.findByIdListAndTenantCode(ids, TenantUtils.getTenantCode());
            this.tpmAccountReconciliationFactorEntityMapper.deleteByIdList(ids);
            for (TpmAccountReconciliationFactorEntity entity : entityList) {
                TpmAccountReconciliationFactorLogDto logDto = new TpmAccountReconciliationFactorLogDto();
                logDto.setOriginal((TpmAccountReconciliationFactorDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, TpmAccountReconciliationFactorDto.class, LinkedHashSet.class, ArrayList.class, new String[0]));
                TpmAccountReconciliationFactorDto newest = logDto.getOriginal();
                newest.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
                logDto.setNewest(newest);
                this.tpmAccountReconciliationFactorLogEventListener.onDelete(logDto);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void enable(List<String> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            List<TpmAccountReconciliationFactorEntity> entityList = this.tpmAccountReconciliationFactorEntityMapper.findByIdListAndTenantCode(ids, TenantUtils.getTenantCode());
            this.tpmAccountReconciliationFactorEntityMapper.enable(ids);
            for (TpmAccountReconciliationFactorEntity entity : entityList) {
                TpmAccountReconciliationFactorLogDto logDto = new TpmAccountReconciliationFactorLogDto();
                TpmAccountReconciliationFactorDto original = new TpmAccountReconciliationFactorDto();
                original.setId(entity.getId());
                original.setEnableStatus(entity.getEnableStatus());
                original.setTenantCode(TenantUtils.getTenantCode());
                logDto.setOriginal(original);
                this.tpmAccountReconciliationFactorLogEventListener.onEnable(logDto);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void disable(List<String> ids) {
        if (!CollectionUtils.isEmpty(ids)) {
            List<TpmAccountReconciliationFactorEntity> entityList = this.tpmAccountReconciliationFactorEntityMapper.findByIdListAndTenantCode(ids, TenantUtils.getTenantCode());
            this.tpmAccountReconciliationFactorEntityMapper.disable(ids);
            for (TpmAccountReconciliationFactorEntity entity : entityList) {
                TpmAccountReconciliationFactorLogDto logDto = new TpmAccountReconciliationFactorLogDto();
                TpmAccountReconciliationFactorDto original = new TpmAccountReconciliationFactorDto();
                original.setId(entity.getId());
                original.setEnableStatus(entity.getEnableStatus());
                original.setTenantCode(TenantUtils.getTenantCode());
                logDto.setOriginal(original);
                this.tpmAccountReconciliationFactorLogEventListener.onDisable(logDto);
            }
        }
    }

    public boolean checkFactorCodeList(List<String> factorCodeList) {
        List<TpmAccountReconciliationFactorRespVo> factorList = this.tpmAccountReconciliationFactorEntityRepository.findByFactorCodeList(factorCodeList);
        return !CollectionUtils.isEmpty(factorList) && factorCodeList.size() == factorList.size();
    }

    public List<TpmAccountReconciliationFactorRespVo> findByFactorCodeList(List<String> factorCodeList) {
        if (CollectionUtil.isEmpty(factorCodeList)) {
            return Collections.emptyList();
        }
        List<TpmAccountReconciliationFactorRespVo> factorList = this.tpmAccountReconciliationFactorEntityRepository.findByFactorCodeList(factorCodeList);
        for (TpmAccountReconciliationFactorRespVo respVo : factorList) {
            if (!ModalTypeEnum.DETAIL.getCode().equals(respVo.getComponentName()) && !ModalTypeEnum.SUMMARY.getCode().equals(respVo.getComponentName()) && !ModalTypeEnum.TAIL.getCode().equals(respVo.getComponentName())) continue;
            respVo.setFactorConfigList(JSONArray.parseArray((String)respVo.getFactorConfig(), TpmAccountReconciliationFactorColumnConfigVo.class));
        }
        return factorList;
    }

    private TpmAccountReconciliationFactorLogEntity generateLogEntity(String code, String optionType) {
        TpmAccountReconciliationFactorLogEntity logEntity = new TpmAccountReconciliationFactorLogEntity();
        logEntity.setAccountReconciliationFactorCode(code);
        logEntity.setOptionType(optionType);
        return logEntity;
    }
}

