package com.biz.crm.tpm.business.account.reconciliation.rule.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.account.reconciliation.rule.feign.feign.AccountReconciliationRuleFeign;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.dto.TpmAccountReconciliationRuleDto;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.service.TpmAccountReconciliationRuleService;
import com.biz.crm.tpm.business.account.reconciliation.rule.sdk.vo.TpmAccountReconciliationRuleRespVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @ClassName AccountReconciliationRuleServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/17
 */
@Service
public class AccountReconciliationRuleServiceImpl implements TpmAccountReconciliationRuleService {

    @Autowired(required = false)
    private AccountReconciliationRuleFeign accountReconciliationRuleFeign;

    @Override
    public TpmAccountReconciliationRuleRespVo queryById(String id) {
        Result<TpmAccountReconciliationRuleRespVo> result = accountReconciliationRuleFeign.findById(id);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("查询对账单规则详情失败：" + result.getMessage());
        } else if (result.getResult() != null && DelFlagStatusEnum.DELETE.getCode().equals(result.getResult().getDelFlag())) {
            throw new UnsupportedOperationException("该对账单规则已删除");
        }
        return result.getResult();
    }

    @Override
    public TpmAccountReconciliationRuleDto create(TpmAccountReconciliationRuleDto dto) {
        Result<TpmAccountReconciliationRuleDto> result = accountReconciliationRuleFeign.create(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("创建对账单规则失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public TpmAccountReconciliationRuleDto edit(TpmAccountReconciliationRuleDto dto) {
        Result<TpmAccountReconciliationRuleDto> result = accountReconciliationRuleFeign.update(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("更改对账单规则失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public boolean deleteById(String id) {
        return false;
    }

    @Override
    public void deleteByIdList(List<String> ids) {
        Result<?> result = accountReconciliationRuleFeign.delete(ids);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("删除对账单规则失败：" + result.getMessage());
        }
    }

    @Override
    public void enable(List<String> ids) {

    }

    @Override
    public void disable(List<String> ids) {

    }

    @Override
    public Page<TpmAccountReconciliationRuleRespVo> findCurrentEffectiveRule(Pageable pageRequest) {
        return null;
    }

    @Override
    public TpmAccountReconciliationRuleRespVo findByCode(String code) {
        return null;
    }

    @Override
    public Page<TpmAccountReconciliationRuleRespVo> queryByPage(TpmAccountReconciliationRuleDto TpmAccountReconciliationRuleRespVo, Pageable pageRequest) {
        return null;
    }
}
