/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.notifier;

import com.biz.crm.tpm.business.activities.local.service.ActivitiesDetailSerialService;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesDetailSerialEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailSerialVo;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingExecutorOprtType;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingType;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.BusinessStrategySettingExecutor;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeDetailVo;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivitiesForActivitiesDetailSerialEventListener
implements ActivitiesDetailSerialEventListener {
    private static final Logger log = LoggerFactory.getLogger(ActivitiesForActivitiesDetailSerialEventListener.class);
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired
    private CostTypeDetailVoService costTypeDetailVoService;
    @Autowired
    private ActivitiesDetailSerialService activitiesDetailSerialService;
    @Autowired(required=false)
    private List<BusinessStrategySettingExecutor> businessStrategySettingExecutors;

    public void onCreated(ActivitiesDetailSerialVo activitiesDetailSerialVo) {
        if (activitiesDetailSerialVo == null || StringUtils.isBlank((CharSequence)activitiesDetailSerialVo.getActivitiesDetailCode())) {
            return;
        }
        String activitiesDetailCode = activitiesDetailSerialVo.getActivitiesDetailCode();
        ActivitiesDetailVo activitiesDetailVo = this.activitiesDetailService.findByActivitiesDetailCode(activitiesDetailCode);
        Validate.notNull((Object)activitiesDetailVo, (String)"\u6d3b\u52a8\u8ba2\u5355\u6d3b\u52a8\u660e\u7ec6\u7f16\u53f7\u3010%s\u3011\uff0c\u65e0\u6d3b\u52a8\u660e\u7ec6\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{activitiesDetailCode});
        CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(activitiesDetailVo.getCostTypeDetailCode());
        Validate.notEmpty((Collection)costTypeDetailVo.getSettingStrategies(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u3010%s\u3011\u6ca1\u6709\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costTypeDetailVo.getDetailCode()});
        BusinessStrategySettingExecutor executor = BusinessStrategySettingExecutor.getExecutor(this.businessStrategySettingExecutors, (String)StrategySettingType.ACTIVITY.name());
        Validate.notNull((Object)executor, (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u3010%s\u3011\u6ca1\u6709\u5339\u914d\u5230\u76f8\u5e94\u7684\u7b56\u7565\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{costTypeDetailVo.getDetailCode()});
        boolean isControlEventCosts = executor.matchedOprtType(costTypeDetailVo.getSettingStrategies(), StrategySettingExecutorOprtType.CONTROL_COSTS.name(), (Object)true);
        if (isControlEventCosts) {
            BigDecimal usedAmount;
            BigDecimal applyAmount = activitiesDetailVo.getApplyAmount();
            Validate.isTrue((applyAmount.compareTo(usedAmount = this.activitiesDetailSerialService.findAmountByActivitiesDetailCode(activitiesDetailVo.getActivitiesDetailCode())) >= 0 ? 1 : 0) != 0, (String)"\u6d3b\u52a8\u8d39\u7528\u4f7f\u7528\u8d85\u51fa\u63a7\u5236\u91d1\u989d\u3010%s\u3011", (Object[])new Object[]{applyAmount.toString()});
        }
        this.activitiesDetailService.updateOrderAmountByActivitiesCode(activitiesDetailCode, activitiesDetailSerialVo.getSerialPrice(), true);
    }

    public void onDeleted(ActivitiesDetailSerialVo activitiesDetailSerialVo) {
    }
}

