/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.activities.local.entity.ActivitiesDetailCollectFiles;
import com.biz.crm.tpm.business.activities.local.mapper.ActivitiesDetailCollectFilesMapper;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailCollectFilesDto;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailCollectFilesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivitiesDetailCollectFilesRepository
extends ServiceImpl<ActivitiesDetailCollectFilesMapper, ActivitiesDetailCollectFiles> {
    @Autowired
    private ActivitiesDetailCollectFilesMapper activitiesDetailCollectFilesMapper;

    public Page<ActivitiesDetailCollectFilesVo> findByConditions(Pageable pageable, ActivitiesDetailCollectFilesDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activitiesDetailCollectFilesMapper.findByConditions((Page<ActivitiesDetailCollectFilesVo>)page, dto);
    }

    public List<ActivitiesDetailCollectFiles> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ActivitiesDetailCollectFiles> findByCollectCode(String collectCode) {
        if (StringUtils.isBlank((CharSequence)collectCode)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivitiesDetailCollectFiles::getCollectCode, (Object)collectCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }
}

