/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.activities.local.entity.ActivitiesDetail;
import com.biz.crm.tpm.business.activities.local.mapper.ActivitiesDetailMapper;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivitiesDetailRepository
extends ServiceImpl<ActivitiesDetailMapper, ActivitiesDetail> {
    @Autowired
    private ActivitiesDetailMapper activitiesDetailMapper;

    public Page<ActivitiesDetailVo> findByConditions(Pageable pageable, ActivitiesDetailDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activitiesDetailMapper.findByConditions((Page<ActivitiesDetailVo>)page, dto);
    }

    public List<ActivitiesDetail> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public ActivitiesDetail findByActivitiesDetailCode(String activitesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitesDetailCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (ActivitiesDetail)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivitiesDetail::getActivitiesDetailCode, (Object)activitesDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public List<ActivitiesDetail> findByActivitiesDetailCodes(Collection<String> activitesDetailCodes) {
        if (CollectionUtils.isEmpty(activitesDetailCodes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivitiesDetail::getActivitiesDetailCode, activitesDetailCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ActivitiesDetail> findByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivitiesDetail::getActivitiesCode, (Object)activitiesCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ActivitiesDetail> findByActivitiesCodes(Collection<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivitiesDetail::getActivitiesCode, activitiesCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public int countByCostTypeCategoryCode(String costTypeCategoryCode) {
        if (StringUtils.isBlank((CharSequence)costTypeCategoryCode)) {
            return 0;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(ActivitiesDetail::getCostTypeCategoryCode, (Object)costTypeCategoryCode)).count();
    }

    public int countByActivitiesCodeAndClosed(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return 0;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(ActivitiesDetail::getActivitiesCode, (Object)activitiesCode)).eq(ActivitiesDetail::getIsClose, (Object)BooleanEnum.TRUE.getCapital())).count();
    }

    public boolean updateIsExecutedByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantEntity::getTenantCode, (Object)tenantCode)).eq(ActivitiesDetail::getActivitiesDetailCode, (Object)activitiesDetailCode)).set(ActivitiesDetail::getIsExecute, (Object)BooleanEnum.TRUE.getCapital())).update();
    }
}

