/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.activities.local.entity.ActivitiesDetailSerial;
import com.biz.crm.tpm.business.activities.local.mapper.ActivitiesDetailSerialMapper;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailSerialDto;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesDetailSerialVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivitiesDetailSerialRepository
extends ServiceImpl<ActivitiesDetailSerialMapper, ActivitiesDetailSerial> {
    @Autowired
    private ActivitiesDetailSerialMapper activitiesDetailSerialMapper;

    public Page<ActivitiesDetailSerialVo> findByConditions(Pageable pageable, ActivitiesDetailSerialDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activitiesDetailSerialMapper.findByConditions((Page<ActivitiesDetailSerialVo>)page, dto);
    }

    public List<ActivitiesDetailSerial> findByIds(Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ActivitiesDetailSerial> findByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivitiesDetailSerial::getActivitiesCode, (Object)activitiesCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<ActivitiesDetailSerial> findByActivitiesCodes(Collection<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivitiesDetailSerial::getActivitiesCode, activitiesCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ActivitiesDetailSerial::getActivitiesCode, (Object)activitiesCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public List<ActivitiesDetailSerial> findByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivitiesDetailSerial::getActivitiesDetailCode, (Object)activitiesDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).orderByDesc(ActivitiesDetailSerial::getCreateTime)).list();
    }

    public List<ActivitiesDetailSerial> findByActivitiesDetailCodes(Collection<String> activitiesDetailCodes) {
        if (CollectionUtils.isEmpty(activitiesDetailCodes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(ActivitiesDetailSerial::getActivitiesDetailCode, activitiesDetailCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public boolean deleteByActivitiesDetailCode(String activitiesDetailCode) {
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return false;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(ActivitiesDetailSerial::getActivitiesDetailCode, (Object)activitiesDetailCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).remove();
    }

    public BigDecimal sumAmountByActivitiesCode(String activitiesDetailCode) {
        BigDecimal amount = BigDecimal.ZERO;
        if (StringUtils.isBlank((CharSequence)activitiesDetailCode)) {
            return amount;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.activitiesDetailSerialMapper.sumTotalAmountByActivitiesDetailCode(tenantCode, activitiesDetailCode);
    }
}

