/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.tpm.business.activities.local.entity.Activities;
import com.biz.crm.tpm.business.activities.local.mapper.ActivitiesMapper;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDto;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivitiesRepository
extends ServiceImpl<ActivitiesMapper, Activities> {
    @Autowired
    private ActivitiesMapper activitiesMapper;

    public Page<ActivitiesVo> findByConditions(Pageable pageable, ActivitiesDto dto) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.activitiesMapper.findByConditions((Page<ActivitiesVo>)page, dto);
    }

    public List<Activities> findByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public Activities findByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return null;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return (Activities)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(Activities::getActivitiesCode, (Object)activitiesCode)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).one());
    }

    public List<Activities> findByActivitiesCodes(Set<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(Activities::getActivitiesCode, activitiesCodes)).eq(TenantEntity::getTenantCode, (Object)tenantCode)).list();
    }

    public List<String> findCodeByTime(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return Collections.emptyList();
        }
        String tenantCode = TenantUtils.getTenantCode();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate localDate = LocalDate.parse(StringUtils.join((Object[])new String[]{time, "-01"}), df);
        LocalTime localTime = LocalTime.of(0, 0);
        LocalDateTime dateTime = LocalDateTime.of(localDate, localTime);
        LocalDateTime beginTime = dateTime.with(TemporalAdjusters.firstDayOfMonth());
        LocalDateTime endTime = dateTime.with(TemporalAdjusters.lastDayOfMonth());
        return this.activitiesMapper.findCodeByTime(tenantCode, beginTime, endTime);
    }

    public int countByCostTypeCategoryCode(String costTypeCategoryCode) {
        if (StringUtils.isBlank((CharSequence)costTypeCategoryCode)) {
            return 0;
        }
        String tenantCode = TenantUtils.getTenantCode();
        return this.activitiesMapper.countByCostTypeCategoryCode(tenantCode, costTypeCategoryCode);
    }
}

