/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activities.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.tpm.business.activities.local.entity.Activities;
import com.biz.crm.tpm.business.activities.local.repository.ActivitiesRepository;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDetailDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesDto;
import com.biz.crm.tpm.business.activities.sdk.dto.ActivitiesShareDto;
import com.biz.crm.tpm.business.activities.sdk.event.ActivitiesFilterEventListener;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesDetailService;
import com.biz.crm.tpm.business.activities.sdk.service.ActivitiesService;
import com.biz.crm.tpm.business.activities.sdk.strategy.share.ActivitiesShareStrategy;
import com.biz.crm.tpm.business.activities.sdk.vo.ActivitiesVo;
import com.biz.crm.tpm.business.activities.sdk.vo.BasicActivityItemVo;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingExecutorOprtType;
import com.biz.crm.tpm.business.budget.sdk.enums.StrategySettingType;
import com.biz.crm.tpm.business.budget.sdk.service.CostTypeDetailVoService;
import com.biz.crm.tpm.business.budget.sdk.strategy.setting.BusinessStrategySettingExecutor;
import com.biz.crm.tpm.business.budget.sdk.vo.CostTypeDetailVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="activitiesVoService")
public class ActivitiesServiceImpl
implements ActivitiesService {
    @Autowired
    private ActivitiesRepository activitiesRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private CostTypeDetailVoService costTypeDetailVoService;
    @Autowired
    private ActivitiesDetailService activitiesDetailService;
    @Autowired(required=false)
    private List<ActivitiesShareStrategy> shareStrategies;
    @Autowired(required=false)
    private List<ActivitiesFilterEventListener> activitiesFilterEventListeners;
    @Autowired(required=false)
    private List<BusinessStrategySettingExecutor> businessStrategySettingExecutors;

    public Page<ActivitiesVo> findByConditions(Pageable pageable, ActivitiesDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (Objects.isNull(dto)) {
            dto = new ActivitiesDto();
        }
        HashSet excludeActivitiesCodes = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(this.activitiesFilterEventListeners)) {
            for (ActivitiesFilterEventListener activitiesFilterEventListener : this.activitiesFilterEventListeners) {
                excludeActivitiesCodes.addAll(activitiesFilterEventListener.filterActivitiesCode(dto));
            }
        }
        dto.setExcludeActivitiesCodes((Set)excludeActivitiesCodes);
        return this.activitiesRepository.findByConditions(pageable, dto);
    }

    private void extendDataHandler(List<BasicActivityItemVo> basicActivityItemVos) {
        basicActivityItemVos.forEach(item -> {
            CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(item.getCostTypeDetailCode());
            item.setCostTypeDetailVo(costTypeDetailVo);
        });
    }

    public ActivitiesVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Activities activities = (Activities)((Object)this.activitiesRepository.getById((Serializable)((Object)id)));
        if (activities == null) {
            return null;
        }
        return (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activities, ActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public ActivitiesVo findByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return null;
        }
        Activities activities = this.activitiesRepository.findByActivitiesCode(activitiesCode);
        if (activities == null) {
            return null;
        }
        return (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activities, ActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivitiesVo> findByActivitiesCodes(Set<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Lists.newArrayList();
        }
        List<Activities> activities = this.activitiesRepository.findByActivitiesCodes(activitiesCodes);
        if (CollectionUtils.isEmpty(activities)) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(activities, Activities.class, ActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]));
    }

    public ActivitiesVo findDetailsByActivitiesCode(String activitiesCode) {
        if (StringUtils.isBlank((CharSequence)activitiesCode)) {
            return null;
        }
        Activities activities = this.activitiesRepository.findByActivitiesCode(activitiesCode);
        if (activities == null) {
            return null;
        }
        ActivitiesVo activitiesVo = (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activities, ActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List detailsVos = this.activitiesDetailService.findByActivitiesCode(activitiesVo.getActivitiesCode());
        activitiesVo.setActivitiesDetails(detailsVos);
        return activitiesVo;
    }

    @Transactional
    public ActivitiesVo create(ActivitiesDto activitiesDto) {
        this.createValidate(activitiesDto);
        Set activitiesDetails = activitiesDto.getActivitiesDetails();
        int detailNum = activitiesDetails.size();
        int waitAuditDetailNum = 0;
        int autoAuditDetailNum = 0;
        for (ActivitiesDetailDto activitiesDetailDto : activitiesDetails) {
            String costTypeDetailCode = activitiesDetailDto.getCostTypeDetailCode();
            CostTypeDetailVo costTypeDetailVo = this.costTypeDetailVoService.findByCode(costTypeDetailCode);
            Validate.notEmpty((Collection)costTypeDetailVo.getSettingStrategies(), (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u3010%s\u3011\u6ca1\u6709\u7b56\u7565\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{costTypeDetailVo.getDetailCode()});
            BusinessStrategySettingExecutor executor = BusinessStrategySettingExecutor.getExecutor(this.businessStrategySettingExecutors, (String)StrategySettingType.AUDIT.name());
            Validate.notNull((Object)executor, (String)"\u6d3b\u52a8\u7ec6\u7c7b\u7f16\u53f7\u3010%s\u3011\u6ca1\u6709\u5339\u914d\u5230\u76f8\u5e94\u7684\u7b56\u7565\u6267\u884c\u5668\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[]{costTypeDetailVo.getDetailCode()});
            boolean isAudit = executor.matchedOprtType(costTypeDetailVo.getSettingStrategies(), StrategySettingExecutorOprtType.IS_AUDIT.name(), (Object)true);
            boolean autoAudit = executor.matchedOprtType(costTypeDetailVo.getSettingStrategies(), StrategySettingExecutorOprtType.AUTO_AUDIT.name(), (Object)true);
            if (isAudit) {
                ++waitAuditDetailNum;
            }
            if (!autoAudit) continue;
            ++autoAuditDetailNum;
        }
        Activities activities = (Activities)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)activitiesDto, Activities.class, LinkedHashSet.class, ArrayList.class, new String[0]));
        activities.setDetailNum(detailNum);
        activities.setWaitAuditDetailNum(waitAuditDetailNum);
        activities.setAutoAuditDetailNum(autoAuditDetailNum);
        activities.setTenantCode(TenantUtils.getTenantCode());
        if (waitAuditDetailNum - autoAuditDetailNum == 0) {
            activities.setIsAudit(BooleanEnum.TRUE.getCapital());
        } else {
            activities.setIsAudit(BooleanEnum.FALSE.getCapital());
        }
        activities.setIsClose(BooleanEnum.FALSE.getCapital());
        this.activitiesRepository.saveOrUpdate((Object)activities);
        ActivitiesVo activitiesVo = (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activities, ActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        activitiesDetails.forEach(item -> item.setActivitiesCode(activities.getActivitiesCode()));
        List activitiesDetailVos = this.activitiesDetailService.createBatch((Collection)activitiesDetails);
        activitiesVo.setActivitiesDetails(activitiesDetailVos);
        return activitiesVo;
    }

    @Transactional
    public ActivitiesVo update(ActivitiesDto activitiesDto) {
        this.updateValidate(activitiesDto);
        Activities activities = this.activitiesRepository.findByActivitiesCode(activitiesDto.getActivitiesCode());
        activities.setIsClose(activitiesDto.getIsClose());
        this.activitiesRepository.saveOrUpdate((Object)activities);
        ActivitiesVo activitiesVo = (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activities, ActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        List activitiesDetailVos = this.activitiesDetailService.findByActivitiesCode(activitiesVo.getActivitiesCode());
        activitiesVo.setActivitiesDetails(activitiesDetailVos);
        return activitiesVo;
    }

    public List<?> shareForFeeDate(ActivitiesShareDto dto) {
        ActivitiesShareStrategy shareStrategy = this.getShareStrategy(dto);
        Validate.notNull((Object)shareStrategy, (String)"\u6839\u636e\u6307\u5b9a\u7684\u52a8\u6001\u8868\u5355\u7f16\u7801\u3010%s\u3011\uff0c\u672a\u80fd\u83b7\u53d6\u5230\u76f8\u5e94\u5206\u644a\u7b56\u7565", (Object[])new Object[]{dto.getDynamicFormCode()});
        return shareStrategy.share(dto);
    }

    @Transactional
    public ActivitiesVo updateForAudit(String activitiesCode) {
        Activities activities = this.activitiesRepository.findByActivitiesCode(activitiesCode);
        Validate.notNull((Object)((Object)activities), (String)"\u6d3b\u52a8\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5 \uff01", (Object[])new Object[0]);
        activities.setIsAudit(BooleanEnum.TRUE.getCapital());
        this.activitiesRepository.saveOrUpdate((Object)activities);
        return (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activities, ActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public ActivitiesVo closeForAudit(String activitiesCode) {
        Activities activities = this.activitiesRepository.findByActivitiesCode(activitiesCode);
        Validate.notNull((Object)((Object)activities), (String)"\u6d3b\u52a8\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5 \uff01", (Object[])new Object[0]);
        activities.setIsClose(BooleanEnum.TRUE.getCapital());
        this.activitiesRepository.saveOrUpdate((Object)activities);
        return (ActivitiesVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)activities, ActivitiesVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    public List<ActivitiesVo> findDetailsByActivitiesCodes(Set<String> activitiesCodes) {
        if (CollectionUtils.isEmpty(activitiesCodes)) {
            return Lists.newArrayList();
        }
        List<ActivitiesVo> activities = this.findByActivitiesCodes(activitiesCodes);
        if (CollectionUtils.isEmpty(activities)) {
            return Lists.newArrayList();
        }
        Map details = this.activitiesDetailService.findByActivitiesCodes(activitiesCodes);
        if (CollectionUtils.isEmpty((Map)details)) {
            return activities;
        }
        block0: for (Map.Entry entry : details.entrySet()) {
            for (ActivitiesVo activitiesVo : activities) {
                if (!StringUtils.equals((CharSequence)activitiesVo.getActivitiesCode(), (CharSequence)((CharSequence)entry.getKey()))) continue;
                activitiesVo.setActivitiesDetails((List)entry.getValue());
                continue block0;
            }
        }
        return activities;
    }

    public List<String> findCodeByTime(String time) {
        if (StringUtils.isBlank((CharSequence)time)) {
            return null;
        }
        return this.activitiesRepository.findCodeByTime(time);
    }

    public boolean existsByCostCategory(String costTypeCategoryCode) {
        int count = this.activitiesDetailService.countByCostTypeCategoryCode(costTypeCategoryCode);
        return count > 0;
    }

    private void createValidate(ActivitiesDto activitiesDto) {
        Validate.notNull((Object)activitiesDto, (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDto.getActivitiesCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDto.getActivitiesName(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDto.getActivityMark(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesDto.getBeginTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesDto.getEndTime(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty((Collection)activitiesDto.getActivitiesDetails(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6d3b\u52a8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(ActivitiesDto activitiesDto) {
        Validate.notNull((Object)activitiesDto, (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDto.getId(), (String)"\u4fee\u6539\u65f6\uff0c\u4e3b\u952e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDto.getActivitiesCode(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDto.getActivitiesName(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activitiesDto.getActivityMark(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesDto.getBeginTime(), (String)"\u4fee\u6539\u65f6\uff0c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesDto.getEndTime(), (String)"\u4fee\u6539\u65f6\uff0c\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)activitiesDto.getIsClose(), (String)"\u4fee\u6539\u65f6\uff0c\u6d3b\u52a8\u5173\u95ed\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private ActivitiesShareStrategy getShareStrategy(ActivitiesShareDto dto) {
        if (CollectionUtils.isEmpty(this.shareStrategies)) {
            return null;
        }
        Validate.notNull((Object)dto, (String)"\u4f20\u5165\u7684\u5f85\u5206\u644a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Date startTime = dto.getStartTime();
        Date endTime = dto.getEndTime();
        String dynamicFormCode = dto.getDynamicFormCode();
        JSONObject dynamicForm = dto.getDynamicForm();
        Validate.notNull((Object)startTime, (String)"\u6d3b\u52a8\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)endTime, (String)"\u6d3b\u52a8\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dynamicFormCode, (String)"\u52a8\u6001\u8868\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notEmpty((Map)dynamicForm, (String)"\u52a8\u6001\u8868\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        for (ActivitiesShareStrategy shareStrategy : this.shareStrategies) {
            if (!StringUtils.equals((CharSequence)shareStrategy.dynamicFormCode(), (CharSequence)dto.getDynamicFormCode())) continue;
            return shareStrategy;
        }
        return null;
    }
}

