package com.biz.crm.tpm.business.activity.customer.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.customer.cost.sdk.dto.ActivityCustomerCostDto;
import com.biz.crm.tpm.business.activity.customer.cost.sdk.service.ActivityCustomerCostService;
import com.biz.crm.tpm.business.activity.customer.cost.sdk.vo.ActivityCustomerCostVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author: chenlong
 * @date: 2022/11/21 9:38
 * @description: 客户费比跟踪表(ActivityCustomerCost)表相关的http接口
 */
@RestController
@RequestMapping("/v1/activityCustomerCost")
@Slf4j
@Api(tags = "客户费比跟踪表")
public class ActivityCustomerCostController {

    @Autowired
    private ActivityCustomerCostService activityCustomerCostService;

    /**
     * 分页查询所有数据
     *
     * @param pageable                分页对象
     * @param activityCustomerCostDto 查询dto
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<ActivityCustomerCostVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                 @ApiParam(name = "activityCustomerCostDto", value = "客户费比跟踪表Dto") ActivityCustomerCostDto activityCustomerCostDto) {
        try {
            Page<ActivityCustomerCostVo> page = this.activityCustomerCostService.findByConditions(pageable, activityCustomerCostDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
