package com.biz.crm.tpm.business.activity.customer.cost.local.service.internal;

import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customer.sdk.dto.CustomerSelectDto;
import com.biz.crm.mdm.business.customer.sdk.service.CustomerVoService;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerVo;
import com.biz.crm.mdm.business.sales.org.sdk.service.SalesOrgVoService;
import com.biz.crm.mdm.business.sales.org.sdk.vo.SalesOrgVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.customer.cost.sdk.dto.ActivityCustomerCostDto;
import com.biz.crm.tpm.business.activity.customer.cost.sdk.service.ActivityCustomerCostService;
import com.biz.crm.tpm.business.activity.customer.cost.sdk.vo.ActivityCustomerCostVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemStatisticsDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.audit.sdk.dto.CustomerCostAuditStatisticsDto;
import com.biz.crm.tpm.business.audit.sdk.service.AuditService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmDailySalesDataTotalDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmDailySalesDataService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmDailySalesDataVo;
import com.biz.crm.tpm.business.examine.circular.sdk.dto.CustomerCostAssessedAmountStatisticsDto;
import com.biz.crm.tpm.business.examine.circular.sdk.service.TpmExamineCircularService;
import com.biz.crm.tpm.business.examine.circular.sdk.vo.CustomerCostAssessedAmountStatisticsVo;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.dto.MainOnedaySalesDataDto;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.service.MainOnedaySaleDataService;
import com.biz.crm.tpm.business.main.oneday.sale.data.sdk.vo.MainOnedaySalesDataVo;
import com.biz.crm.tpm.business.sales.goal.sdk.dto.SalesGoalStatisticsDto;
import com.biz.crm.tpm.business.sales.goal.sdk.service.SalesGoalService;
import com.biz.crm.tpm.business.sales.goal.sdk.vo.SalesGoalStatisticsVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.math.RoundingMode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * @author: chenlong
 * @date: 2022/11/21 9:46
 * @description:
 */
@Service("ActivityCustomerCostService")
@Slf4j
public class ActivityCustomerCostServiceImpl implements ActivityCustomerCostService {

    @Autowired(required = false)
    private SalesOrgVoService salesOrgVoService;
    @Autowired(required = false)
    private SalesGoalService salesGoalService;
    @Autowired(required = false)
    private AuditService auditService;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required = false)
    private TpmExamineCircularService tpmExamineCircularService;
    @Autowired(required = false)
    private CustomerVoService customerVoService;
    @Autowired(required = false)
    private MainOnedaySaleDataService mainOnedaySaleDataService;
    @Autowired(required = false)
    private TpmDailySalesDataService tpmDailySalesDataService;

    /**
     * 业态：常温
     */
    private static final String CW = "11";
    /**
     * 业务单元：主体
     */
    private static final String ZT = "DY00000008";
    /**
     * 客户渠道：20
     */
    private static final String QD = "20";
    /**
     * 销售机构：6000
     */
    private static final String XSJG = "6000";


    /**
     * 分页查询数据
     *
     * @param pageable                分页对象
     * @param dto 查询dto
     * @return Page<ActivityCustomerCostVo>
     */
    @Override
    public Page<ActivityCustomerCostVo> findByConditions(Pageable pageable, ActivityCustomerCostDto dto) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(dto)) {
            dto = new ActivityCustomerCostDto();
        }
        String tenantCode = TenantUtils.getTenantCode();
        dto.setTenantCode(tenantCode);
        //获取区域及其下级
//        if (!CollectionUtils.isEmpty(dto.getAreaCodeList())) {
//            List<SalesOrgVo> orgList = salesOrgVoService.findAllChildrenBySalesOrgCodes(dto.getAreaCodeList());
//            if (!CollectionUtils.isEmpty(orgList)) {
//                List<String> salesorgCodes = orgList.stream().map(SalesOrgVo::getSalesOrgCode).collect(Collectors.toList());
//                dto.setSalesOrgCodes(salesorgCodes);
//            }
//        }
        //年月默认为当前年月
        if (null == dto.getYearMonthBegin()) {
            dto.setYearMonthBegin(DateUtil.getDate(DateUtil.date_yyyy_MM));
        }
        if (null == dto.getYearMonthEnd()) {
            dto.setYearMonthEnd(DateUtil.getDate(DateUtil.date_yyyy_MM));
        }

        CustomerSelectDto customerDto = new CustomerSelectDto();
        customerDto.setBusinessFormatCode(CW);
        customerDto.setCustomerChannelCode(StringUtils.isBlank(dto.getCustomerChannelCode()) ? QD : dto.getCustomerChannelCode());
        customerDto.setSalesInstitutionErpCode(StringUtils.isBlank(dto.getSalesInstitutionCode()) ? XSJG : dto.getSalesInstitutionCode());
        customerDto.setSalesRegionErpCode(dto.getSalesRegionErpCode());
        customerDto.setSalesRegionCode(dto.getSalesRegionCode());
        customerDto.setSalesOrgCode(dto.getSalesOrgCode());
        customerDto.setSalesOrgErpCode(dto.getSalesOrgErpCode());
        customerDto.setCustomerCode(dto.getCustomerCode());
        customerDto.setCustomerName(dto.getCustomerName());
        customerDto.setErpCode(dto.getErpCode());
        customerDto.setSalesOrgName(dto.getSalesOrgName());
        customerDto.setSalesRegionName(dto.getSalesRegionName());
        log.info("查询客户维度参数{}", JSON.toJSONString(customerDto));
        //查询客户维度
        Page<CustomerVo> customerVoPage = customerVoService.findByCustomerSelectDto(pageable, customerDto);
        Page<ActivityCustomerCostVo> costVoPage =
                new Page<>(customerVoPage.getCurrent(), customerVoPage.getSize(), customerVoPage.getTotal(), customerVoPage.isSearchCount());
        log.info("查询客户维度{}", JSON.toJSONString(customerVoPage));
        if (CollectionUtils.isEmpty(customerVoPage.getRecords())) {
            return costVoPage;
        }
        List<CustomerVo> records = customerVoPage.getRecords();
        Collection<ActivityCustomerCostVo> list = this.nebulaToolkitService.copyCollectionByBlankList(records, CustomerVo.class, ActivityCustomerCostVo.class, HashSet.class, ArrayList.class);
        List<String> customerCodes = records.stream().map(e -> e.getCustomerCode()).collect(Collectors.toList());

        SalesGoalStatisticsDto statisticsDto = new SalesGoalStatisticsDto();
        statisticsDto.setYearMonthBegin(DateUtil.dateToStr(DateUtil.date_yyyy_MM, dto.getYearMonthBegin()));
        statisticsDto.setYearMonthEnd(DateUtil.dateToStr(DateUtil.date_yyyy_MM, dto.getYearMonthEnd()));
        statisticsDto.setCustomerCodeList(customerCodes);
        statisticsDto.setTenantCode(tenantCode);
        statisticsDto.setBusinessUnitCodeNotInList(Arrays.asList(BusinessUnitEnum.MODERN_ANIMAL_HUSBANDRY.getCode(), BusinessUnitEnum.STUDENT_MILK.getCode(), BusinessUnitEnum.SHENGMU.getCode(),
                BusinessUnitEnum.MILK_BEVERAGE.getCode()));
        Page<SalesGoalStatisticsVo> goalPage = salesGoalService.findByConditions(pageable, statisticsDto);
        Map<String, BigDecimal> goalMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(goalPage.getRecords())) {
            goalMap = goalPage.getRecords().stream().collect(
                    Collectors.toMap(SalesGoalStatisticsVo::getCustomerCode, SalesGoalStatisticsVo::getTaskQuantity));
        }

        //主体日销售数据+主体日销售明细表（033）
        MainOnedaySalesDataDto mainDto = new MainOnedaySalesDataDto();
        mainDto.setYearMonthLyBegin(DateUtil.dateToStr(DateUtil.date_yyyyMM, dto.getYearMonthBegin()) + "01");
        mainDto.setYearMonthLyEnd(DateUtil.dateToStr(DateUtil.date_yyyyMM, DateUtil.dateAddMonth(dto.getYearMonthEnd(), 1)) + "01");
        mainDto.setCustomerCodeList(customerCodes);
        mainDto.setExcludeBusinessUnitCodeList(Arrays.asList(BusinessUnitEnum.MODERN_ANIMAL_HUSBANDRY.getCode(), BusinessUnitEnum.STUDENT_MILK.getCode(), BusinessUnitEnum.SHENGMU.getCode(),
                BusinessUnitEnum.MILK_BEVERAGE.getCode()));
        List<MainOnedaySalesDataVo> mainOnedaySalesDataVos = mainOnedaySaleDataService.listMainOnedaySalesData(mainDto);
        Map<String, BigDecimal> salesMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(mainOnedaySalesDataVos)) {
            salesMap = mainOnedaySalesDataVos.stream().collect(Collectors.groupingBy(MainOnedaySalesDataVo::getCustomerCode,
                    Collectors.reducing(BigDecimal.ZERO, e -> Optional.ofNullable(e.getDiscountBehindSaleAmount()).orElse(BigDecimal.ZERO), BigDecimal::add)));
        }
        TpmDailySalesDataTotalDto dailySalesDataDto = new TpmDailySalesDataTotalDto();
        dailySalesDataDto.setYearMonthBegin(DateUtil.dateToStr(DateUtil.date_yyyyMM, dto.getYearMonthBegin()) + "01");
        dailySalesDataDto.setYearMonthEnd(DateUtil.dateToStr(DateUtil.date_yyyyMM, DateUtil.dateAddMonth(dto.getYearMonthEnd(), 1)) + "01");
        dailySalesDataDto.setCustomerCodeList(customerCodes);
        List<TpmDailySalesDataVo> dailySalesDataVoList = tpmDailySalesDataService.findByCondition(dailySalesDataDto);
        if (!CollectionUtils.isEmpty(dailySalesDataVoList)) {
            for (TpmDailySalesDataVo vo : dailySalesDataVoList) {
                if (salesMap.containsKey(vo.getCustomerCode())) {
                    salesMap.put(vo.getCustomerCode(), vo.getAfterDiscountAmt().add(salesMap.get(vo.getCustomerCode())));
                } else {
                    salesMap.put(vo.getCustomerCode(), vo.getAfterDiscountAmt());
                }
            }
        }

        //获取结案费用
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(dto.getYearMonthEnd());
        calendar.add(Calendar.MONTH, 1);
        CustomerCostAuditStatisticsDto auditDto = new CustomerCostAuditStatisticsDto();
        auditDto.setTimeBegin(dto.getYearMonthBegin());
        auditDto.setTimeEnd(calendar.getTime());
        auditDto.setTenantCode(tenantCode);
        auditDto.setCustomerCodeList(customerCodes);
        log.info("获取结案费用参数{}", JSON.toJSONString(auditDto));
        Map<String, BigDecimal> auditMap = auditService.listAuditStatistics(auditDto);
        log.info("获取结案费用{}", JSON.toJSONString(auditMap));
        //查询批复费用
        ActivityDetailPlanItemStatisticsDto piDto = this.nebulaToolkitService.copyObjectByBlankList(
                auditDto, ActivityDetailPlanItemStatisticsDto.class, HashSet.class, ArrayList.class);
        piDto.setCustomerCodeList(customerCodes);
        log.info("查询批复费用参数{}", JSON.toJSONString(piDto));
        Map<String, BigDecimal> planMap = activityDetailPlanItemSdkService.statisticsFeeAmountByCusOrgCodes(piDto);
        log.info("查询批复费用{}", JSON.toJSONString(planMap));
        //获取考核费用
        CustomerCostAssessedAmountStatisticsDto assessedAmountStatisticsDto = new CustomerCostAssessedAmountStatisticsDto();
        assessedAmountStatisticsDto.setTimeBegin(dto.getYearMonthBegin());
        assessedAmountStatisticsDto.setTimeEnd(calendar.getTime());
        assessedAmountStatisticsDto.setCustomerCodeList(customerCodes);
        assessedAmountStatisticsDto.setTenantCode(tenantCode);
        List<CustomerCostAssessedAmountStatisticsVo> assessedAmountList = tpmExamineCircularService.listAssessedAmountByOrgCusCodes(assessedAmountStatisticsDto);
        Map<String, BigDecimal> assessedAmountMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(assessedAmountList)) {
            assessedAmountMap = assessedAmountList.stream().collect(
                    Collectors.toMap(CustomerCostAssessedAmountStatisticsVo::getCustomerCode, CustomerCostAssessedAmountStatisticsVo::getAssessedAmount));
        }
        for (ActivityCustomerCostVo vo : list) {
            String key = vo.getCustomerCode();
            //设置实际销售额
            vo.setActualSalesVolume(salesMap.getOrDefault(key, BigDecimal.ZERO));

            vo.setWorkAmount(goalMap.getOrDefault(key, BigDecimal.ZERO));
            BigDecimal replyCaseCost = BigDecimal.ZERO;
            if (auditMap.containsKey(key)) {
                replyCaseCost = replyCaseCost.add(auditMap.getOrDefault(key, BigDecimal.ZERO));
            } else if (planMap.containsKey(key)) {
                replyCaseCost = replyCaseCost.add(planMap.getOrDefault(key, BigDecimal.ZERO));
            }
            vo.setReplyCaseCost(replyCaseCost);

            vo.setAssessDeduction(assessedAmountMap.getOrDefault(key, BigDecimal.ZERO));
            if (BigDecimal.ZERO.compareTo(vo.getWorkAmount()) != 0) {
                vo.setSalesAchieveProgress(vo.getActualSalesVolume().divide(vo.getWorkAmount(), 2, RoundingMode.HALF_UP));
            }
            if (BigDecimal.ZERO.compareTo(vo.getActualSalesVolume()) != 0) {
                vo.setCostRatio((vo.getReplyCaseCost().subtract(vo.getAssessDeduction())).divide(vo.getActualSalesVolume(), 2, RoundingMode.HALF_UP));
            }
            if (vo.getCostRatio() != null) {
                vo.setCostRatioStr(vo.getCostRatio().divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP) + "%");
            }
            if (vo.getSalesAchieveProgress() != null) {
                vo.setSalesAchieveProgressStr(vo.getSalesAchieveProgress().divide(new BigDecimal("100"), 2, RoundingMode.HALF_UP) + "%");
            }
            vo.setYearMonthBegin(dto.getYearMonthBegin());
            vo.setYearMonthEnd(dto.getYearMonthEnd());
        }
        costVoPage.setRecords((List<ActivityCustomerCostVo>) list);


        costVoPage.setTotal(customerVoPage.getTotal());
        costVoPage.setCountId(customerVoPage.getCountId());
        costVoPage.setCurrent(customerVoPage.getCurrent());
        costVoPage.setSize(customerVoPage.getSize());
        costVoPage.setPages(customerVoPage.getPages());
        return costVoPage;
    }

    public static void main(String[] args) {
        Date date1 = DateUtil.getDate(DateUtil.date_yyyy_MM);
        System.out.println(date1);
        System.out.println(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd_HH_mm_ss_SSS, date1));
        Calendar calendar = DateUtil.getCalendar();
        calendar.setTime(date1);
        calendar.add(Calendar.MONTH, 1);
        System.out.println(DateUtil.dateToStr(DateUtil.date_yyyy_MM_dd_HH_mm_ss_SSS, calendar.getTime()));
    }
}
