package com.biz.crm.tpm.business.activity.customer.cost.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author: chenlong
 * @date: 2022/11/21 10:19
 * @description: 客户费比跟踪表Dto
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityCustomerCostDto", description = "客户费比跟踪表Dto")
public class ActivityCustomerCostDto extends TenantFlagOpDto {

    @ApiModelProperty("业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("客户编码")
    private String customerCode;

    @ApiModelProperty("客户名称")
    private String customerName;

    @ApiModelProperty("客户渠道编码")
    private String customerChannelCode;

    @ApiModelProperty("客户渠道名称")
    private String customerChannelName;

    @ApiModelProperty("销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("销售机构名称")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售部门编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售部门名称")
    private String salesRegionName;

    @ApiModelProperty("所属销售组编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组名称")
    private String salesOrgName;

    @ApiModelProperty("任务额(万元)")
    private BigDecimal workAmount;

    @ApiModelProperty("实际销售额(万元)")
    private BigDecimal actualSalesVolume;

    @ApiModelProperty("销售达成进度")
    private BigDecimal salesAchieveProgress;

    @ApiModelProperty("批复+结案费用(万元)")
    private BigDecimal replyCaseCost;

    @ApiModelProperty("考核扣款(万元)")
    private BigDecimal assessDeduction;

    @ApiModelProperty("费比")
    private BigDecimal costRatio;

    @ApiModelProperty("开始年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearMonthBegin;

    @ApiModelProperty("结束年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date yearMonthEnd;

    @ApiModelProperty("销售组织编码列表")
    private List<String> salesOrgCodes;

    @ApiModelProperty("所属销售部门编码(短)")
    private String salesRegionErpCode;

    @ApiModelProperty("客户编码(短)")
    private String erpCode;

    @ApiModelProperty("所属销售组编码(短)")
    private String salesOrgErpCode;
}
