package com.biz.crm.tpm.business.activity.design.monitor.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.dto.TpmActivityDesignMonitorDto;
import com.biz.crm.tpm.business.activity.design.monitor.sdk.vo.TpmActivityDesignMonitorVo;
import org.springframework.data.domain.Pageable;

/**
 * TPM-活动规划监控表(TpmActivityDesignMonitor)表服务接口
 *
 * @author duyiran
 * @since 2022-12-30 09:44:52
 */
public interface TpmActivityDesignMonitorService {

    /**
     * 分页查询数据
     *
     * @param pageable                 分页对象
     * @param dto 实体对象
     * @return 所有记录
     */
    Page<TpmActivityDesignMonitorVo> findByConditions(Pageable pageable, TpmActivityDesignMonitorDto dto);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    TpmActivityDesignMonitorVo findById(String id);

}

