/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.form.local.listener;

import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormAudit;
import com.biz.crm.tpm.business.activity.form.local.service.ActivityFormAuditService;
import com.biz.crm.tpm.business.approval.collect.sdk.event.MnApprovalCollectEventListener;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectVo;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Component
public class MnApprovalCollectEventListenerImpl
implements MnApprovalCollectEventListener {
    @Autowired(required=false)
    private ActivityFormAuditService activityFormAuditService;

    public void onDeleted(MnApprovalCollectVo dto) {
        if (Objects.isNull(dto) || StringUtils.isEmpty((CharSequence)dto.getCode())) {
            return;
        }
        List<ActivityFormAudit> result = this.activityFormAuditService.findByAuditDataCode(dto.getCode());
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        Set codeSet = result.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getActivityFormCode())).map(ActivityFormAudit::getActivityFormCode).collect(Collectors.toSet());
        Assert.isTrue((boolean)CollectionUtils.isEmpty(result), (String)("\u6838\u9500\u91c7\u96c6\u793a\u4f8b" + codeSet.toString() + ";\u5df2\u88ab\u6d3b\u52a8\u5f62\u5f0f\u5173\u8054\u4e0d\u5141\u8bb8\u5220\u9664!"));
    }

    public void onUpdate(MnApprovalCollectVo oldMnApprovalCollectVo, MnApprovalCollectVo newMnApprovalCollectVo) {
    }
}

