/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.form.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityForm;
import com.biz.crm.tpm.business.activity.form.local.mapper.ActivityFormMapper;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormPopEctDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormCodeAndNameVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormPopEctVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

@Component
public class ActivityFormRepository
extends ServiceImpl<ActivityFormMapper, ActivityForm> {
    @Autowired
    private ActivityFormMapper activityFormMapper;

    public Page<ActivityFormVo> findByConditions(Pageable pageable, ActivityFormDto activityForm) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        if (StringUtils.isNotEmpty((CharSequence)activityForm.getActivityTypeCodes())) {
            List activityTypeCodeList = Optional.ofNullable(activityForm.getActivityTypeCodeList()).orElse(Lists.newArrayList());
            activityTypeCodeList.addAll(Arrays.asList(activityForm.getActivityTypeCodes().split(",")));
            activityForm.setActivityTypeCodeList(activityTypeCodeList);
        }
        Page<ActivityFormVo> pageList = this.activityFormMapper.findByConditions((Page<ActivityFormVo>)page, activityForm);
        return pageList;
    }

    public List<ActivityFormVo> findListByConditions(ActivityFormDto activityForm) {
        return this.activityFormMapper.findListByConditions(activityForm);
    }

    public List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            List selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return this.activityFormMapper.findActivityFormSelectList(dto, 50);
    }

    public List<ActivityFormVo> findSelectList(ActivityFormSelectDto dto) {
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectedCode())) {
            List selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return this.activityFormMapper.findSelectList(dto, 50);
    }

    public List<ActivityFormCodeAndNameVo> findFormByCodes(List<List<String>> formCodes, String tenantCode) {
        return this.activityFormMapper.findFormByCodes(formCodes, tenantCode);
    }

    public List<String> findFormByCodesZs03(List<List<String>> formCodes, String tenantCode) {
        return this.activityFormMapper.findFormByCodesZs03(formCodes, tenantCode);
    }

    public List<String> findFormByCodesZs42(List<List<String>> formCodes, String tenantCode) {
        return this.activityFormMapper.findFormByCodesZs42(formCodes, tenantCode);
    }

    public List<ActivityForm> findPushCowManager() {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(ActivityForm::getIsPushPatrolSystem, (Object)BooleanEnum.TRUE.getNumStr())).list();
    }

    public List<ActivityForm> findSapCodeByCodes(List<String> formCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).in(ActivityForm::getActivityFormCode, formCodes)).list();
    }

    public List<ActivityForm> findByIdList(List<String> ids) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, ids)).list();
    }

    public ActivityFormVo findFormAndRelatedTypeCode(String activityFormCode, String tennatCode) {
        if (StringUtils.isBlank((CharSequence)activityFormCode) || StringUtils.isBlank((CharSequence)tennatCode)) {
            return null;
        }
        return ((ActivityFormMapper)this.baseMapper).findFormAndRelatedTypeCode(activityFormCode, tennatCode);
    }

    public ActivityForm findById(String id) {
        return (ActivityForm)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(UuidEntity::getId, (Object)id)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).one());
    }

    public Page<ActivityFormPopEctVo> findActivityFormPopEct(Pageable pageable, ActivityFormPopEctDto activityFormPopEctDto) {
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        Page<ActivityFormPopEctVo> pageList = this.activityFormMapper.findActivityFormPopEct((Page<ActivityFormPopEctVo>)page, activityFormPopEctDto);
        return pageList;
    }

    public List<String> findActivityFormCodeFromPromotionsType(String businessUnitCode, String verticalActivityType, String pushExeSystemCode) {
        return ((ActivityFormMapper)this.baseMapper).findActivityFormCodeFromPromotionsType(businessUnitCode, verticalActivityType, pushExeSystemCode, TenantUtils.getTenantCode());
    }

    public List<ActivityFormVo> findFormAndRelatedTypeCodes(List<String> activityFormCodes, String tenantCode) {
        return ((ActivityFormMapper)this.baseMapper).findFormAndRelatedTypeCodes(activityFormCodes, tenantCode);
    }
}

