package com.biz.crm.tpm.business.activity.intensity.monitor.local.dataview;

import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import org.springframework.stereotype.Component;

/**
 *  活动力度监控表 DataView
 *  * @author miaoqiancheng
 *  * @since 2022-11-17
 */
@Component
public class ActivityIntensityMonitorDataView implements DataviewRegister {

    @Override
    public String code() {
        return "tpm_activity_intensity_monitor";
    }

    @Override
    public String desc() {
        return "TPM-活动力度监控表";
    }

    @Override
    public String buildSql() {
        return "SELECT t.* FROM tpm_activity_intensity_monitor t" +
                "  WHERE t.del_flag = '" + EnableStatusEnum.ENABLE.getCode() + "' "+
                "  AND t.tenant_code = :tenantCode ";
    }

}
