package com.biz.crm.tpm.business.activity.intensity.monitor.local.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 活动力度监控类型枚举
 *
 * @author miaoqiancheng
 * @since 2022-12-9
 */
public enum MonitorTypeEnums {

    HEAD_MONITOR("001","总部监控"),
    CUSTOMER_MONITOR("002","客户监控"),
    REGION_MONITOR("003","大区监控");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private MonitorTypeEnums(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        MonitorTypeEnums[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            MonitorTypeEnums monitorTypeEnum = var1[var3];
            codes.add(monitorTypeEnum.getCode());
        }

        return codes;
    }

    public static MonitorTypeEnums codeToEnum(String code) {
        MonitorTypeEnums monitorTypes = null;
        MonitorTypeEnums[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            MonitorTypeEnums monitorTypeEnum = var2[var4];
            if (monitorTypeEnum.code.equals(code)) {
                monitorTypes = monitorTypeEnum;
            }
        }

        return monitorTypes;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            MonitorTypeEnums[] values = values();
            MonitorTypeEnums[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                MonitorTypeEnums value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            MonitorTypeEnums[] values = values();
            MonitorTypeEnums[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                MonitorTypeEnums value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }

}
