package com.biz.crm.tpm.business.activity.intensity.monitor.local.job;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.constant.ActivityIntensityMonitorConstant;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.service.ActivityIntensityMonitorService;
import com.bizunited.nebula.task.annotations.DynamicTaskService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.concurrent.TimeUnit;

/**
 * 活动力度监控表(tpm_activity_intensity_monitor)服务实现类
 *
 * @author : qiancheng
 * @date : 2022-11-14
 */
@Slf4j
@Service
public class ActivityIntensityMonitorJob {

    @Autowired(required = false)
    private ActivityIntensityMonitorService activityIntensityMonitorService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    @Autowired(required = false)
    private RedisLockService redisLockService;


    /**
     * 活动力度监控表
     */
    @DynamicTaskService(cornExpression = "0 30 3 1 * ?", taskDesc = "每月1号 03:30 执行一次生成活动力度监控表任务")
    public void autoPromotionPlanXxlJob() {
        loginUserService.refreshAuthentication(null);
        boolean lockSuccess = redisLockService.tryLock(ActivityIntensityMonitorConstant.ACTIVITY_INTENSITY_MONITOR, TimeUnit.HOURS, 6);
        Assert.isTrue(lockSuccess, "其他人正在操作数据,加锁失败,请稍后重试!");
        try {

            activityIntensityMonitorService.generateActivityIntensityMonitor(null);
        } finally {
            redisLockService.unlock(ActivityIntensityMonitorConstant.ACTIVITY_INTENSITY_MONITOR);
        }
    }

}
