package com.biz.crm.tpm.business.activity.intensity.monitor.local.service.intenal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.price.sdk.dto.PriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanItemVo;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.vo.ActivityDetailPlanVo;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.entity.ActivityIntensityMonitor;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.enums.IntensityTypeEnum;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.enums.MonitorTypeEnums;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.repository.ActivityIntensityMonitorRepository;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.dto.ActivityIntensityMonitorDto;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.service.ActivityIntensityMonitorService;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ActivityIntensityMonitorVO;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ProductPromotionItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.RoundingMode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动力度监控表(tpm_activity_intensity_monitor)服务实现类
 *
 * @author : qiancheng
 * @date : 2022-11-14
 */
@Slf4j
@Service("activityIntensityMonitorService")
public class ActivityIntensityMonitorServiceImpl implements ActivityIntensityMonitorService {

    @Autowired
    private ActivityIntensityMonitorRepository activityIntensityMonitorRepository;

    @Autowired(required = false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;

    @Autowired(required = false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;

    @Autowired(required = false)
    private ActivityPlanSdkService activityPlanSdkService;

    @Autowired(required = false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;

    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;

    @Autowired(required = false)
    private ProductVoService productVoService;

    @Autowired(required = false)
    private PriceVoService priceVoService;

    /**
     * 分页查询数据
     * @param pageable 分页对象
     * @param activityIntensityMonitor 实体对象
     * @return
     */
    @Override
    public Page<ActivityIntensityMonitorVO> findByConditions(Pageable pageable, ActivityIntensityMonitorDto activityIntensityMonitor) {
        if(pageable == null){
            pageable = PageRequest.of(1,20);
        }
        if(activityIntensityMonitor == null){
            activityIntensityMonitor = new ActivityIntensityMonitorDto();
        }
        if (StringUtils.isBlank(activityIntensityMonitor.getDelFlag())) {
            activityIntensityMonitor.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if(StringUtils.isBlank(activityIntensityMonitor.getTenantCode())){
            activityIntensityMonitor.setTenantCode(TenantUtils.getTenantCode());
        }
        Page<ActivityIntensityMonitorVO> byConditions = this.activityIntensityMonitorRepository.findByConditions(pageable, activityIntensityMonitor);
        /*
            价格、叠加力度计算、偏差率计算
         */
        return byConditions;
    }

    /**
     * 通过主键id 查单条数据
     * @param id 主键id
     * @return 单条数据
     */
    @Override
    public ActivityIntensityMonitorVO findById(String id) {
        if(!StringUtils.isBlank(id)){
            ActivityIntensityMonitor activityIntensityMonitorEntity = activityIntensityMonitorRepository.getById(id);
            if(activityIntensityMonitorEntity != null){
                return nebulaToolkitService.copyObjectByWhiteList(activityIntensityMonitorEntity, ActivityIntensityMonitorVO.class, HashSet.class, ArrayList.class);
            }
        }
        return null;
    }

    /**
     * 查询并保存 活动细案中的产品 促销信息
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void findDateFormActivityDetailPlan() {
        Page<ActivityDetailPlanVo> byConditions1 = null;
        int i = 0;
        List<ActivityIntensityMonitor> activityIntensityMonitorList = new ArrayList<>();

        do{

            PageRequest pageForDetailPlan = PageRequest.of(i, 100);
            ActivityDetailPlanDto detailPlan = new ActivityDetailPlanDto();
            detailPlan.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailPlan.setTenantCode(TenantUtils.getTenantCode());
            detailPlan.setProcessStatus(ProcessStatusEnum.PASS.getKey());
            //审核通过的细案分页
            byConditions1 = activityDetailPlanSdkService.findByConditions(pageForDetailPlan, detailPlan);
            List<ActivityDetailPlanVo> ActivityDetailPlanVoList = byConditions1.getRecords();

            if (ActivityDetailPlanVoList != null && ActivityDetailPlanVoList.size() > 0){
                ActivityDetailPlanVoList.forEach( detailPlanVo ->{
                    Page<ActivityDetailPlanItemVo> byConditions2 = null;
                    int z = 0;
                    do {
                        //审核通过的细案对应的明细  的分页
                        PageRequest pageForDetailPlanItem = PageRequest.of(z, 100);
                        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
                        activityDetailPlanItemDto.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
                        activityDetailPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        byConditions2 = activityDetailPlanItemSdkService.findByConditions(pageForDetailPlanItem, activityDetailPlanItemDto);
                        List<ActivityDetailPlanItemVo> activityDetailPlanItemVoList = byConditions2.getRecords();

                        if(activityDetailPlanItemVoList != null && activityDetailPlanItemVoList.size() > 0){
                            activityDetailPlanItemVoList.forEach( detailPlanItemVo -> {
                                //判断是否关联产品
                                if(!StringUtils.isBlank(detailPlanItemVo.getProductCode())){
                                    ActivityIntensityMonitor activityIntensityMonitor = new ActivityIntensityMonitor();
                                    String detailPlanItemId = detailPlanItemVo.getId();
                                    String productCode = detailPlanItemVo.getProductCode();
                                    activityIntensityMonitor.setId(detailPlanItemId.substring(0,27)+productCode.substring(productCode.length()-5));
                                    activityIntensityMonitor.setBusinessFormatCode(detailPlanVo.getBusinessFormatCode());
                                    activityIntensityMonitor.setBusinessUnitCode(detailPlanVo.getBusinessUnitCode());
                                    activityIntensityMonitor.setMonitorType(MonitorTypeEnums.REGION_MONITOR.getCode());
                                    activityIntensityMonitor.setSalesRegionCode(detailPlanItemVo.getActivityOrgCode());
                                    activityIntensityMonitor.setSalesRegionName(detailPlanItemVo.getActivityOrgName());
                                    activityIntensityMonitor.setProductCode(detailPlanItemVo.getProductCode());
                                    activityIntensityMonitor.setProductName(detailPlanItemVo.getProductName());
                                    activityIntensityMonitor.setPromotionPrice(detailPlanItemVo.getPrice());
                                    activityIntensityMonitor.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                                    activityIntensityMonitor.setTenantCode(TenantUtils.getTenantCode());

                                    activityIntensityMonitorList.add(activityIntensityMonitor);
                                }
                            });
                        }

                        z++;
                    }while (byConditions2 != null && byConditions2.getRecords().size() == 100);

                });
            }
            if(activityIntensityMonitorList.size() >= 100){
                activityIntensityMonitorRepository.saveOrUpdateBatch(activityIntensityMonitorList);
            }
            i++;
        }while (byConditions1 != null && byConditions1.getRecords().size() == 100);

        if(activityIntensityMonitorList.size() > 0){
            activityIntensityMonitorRepository.saveOrUpdateBatch(activityIntensityMonitorList);
        }

    }


    /**
     * 查询并保存 活动方案中关联的产品 促销信息
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void findDateFormActivityPlan() {
        Page<ActivityPlanVo> byConditions1 = null;
        int i = 0;
        List<ActivityIntensityMonitor> activityIntensityMonitorList = new ArrayList<>();

        do{

            PageRequest pageForDetailPlan = PageRequest.of(i, 100);
            ActivityPlanDto activityPlanDto = new ActivityPlanDto();
            activityPlanDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            activityPlanDto.setTenantCode(TenantUtils.getTenantCode());
            activityPlanDto.setProcessStatus(ProcessStatusEnum.PASS.getKey());
            //审核通过的活动方案分页
            byConditions1 = activityPlanSdkService.findByConditions(pageForDetailPlan, activityPlanDto);
            List<ActivityPlanVo> activityPlanVoList = byConditions1.getRecords();

            if (activityPlanVoList != null && activityPlanVoList.size() > 0){
                activityPlanVoList.forEach( activityPlan ->{
                    Page<ActivityPlanItemVo> byConditions2 = null;
                    int z = 0;
                    do {

                        //审核通过的活动方案对应的明细  的分页
                        PageRequest pageForDetailPlanItem = PageRequest.of(z, 100);
                        ActivityPlanItemDto activityPlanItemDto = new ActivityPlanItemDto();
                        activityPlanItemDto.setPlanCode(activityPlan.getPlanCode());
                        activityPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        byConditions2 = activityPlanItemSdkService.findByConditions(pageForDetailPlanItem, activityPlanItemDto);
                        List<ActivityPlanItemVo> activityPlanItemVoList = byConditions2.getRecords();

                        if(activityPlanItemVoList != null && activityPlanItemVoList.size() > 0){
                            activityPlanItemVoList.forEach( activityPlanItemVo -> {
                                //判断是否关联产品
                                if(!StringUtils.isBlank(activityPlanItemVo.getProductCode())){

                                    ActivityIntensityMonitor activityIntensityMonitor = new ActivityIntensityMonitor();
                                    String detailPlanItemId = activityPlanItemVo.getId();
                                    String productCode = activityPlanItemVo.getProductCode();
                                    activityIntensityMonitor.setId(detailPlanItemId.substring(0, 27) + productCode.substring(productCode.length()-5));
                                    activityIntensityMonitor.setBusinessFormatCode(activityPlan.getBusinessFormatCode());
                                    activityIntensityMonitor.setBusinessUnitCode(activityPlan.getBusinessUnitCode());
                                    activityIntensityMonitor.setMonitorType(MonitorTypeEnums.HEAD_MONITOR.getCode());
                                    activityIntensityMonitor.setSalesRegionCode(activityPlanItemVo.getActivityOrgCode());
                                    activityIntensityMonitor.setSalesRegionName(activityPlanItemVo.getActivityOrgName());
                                    activityIntensityMonitor.setProductCode(activityPlanItemVo.getProductCode());
                                    activityIntensityMonitor.setProductName(activityPlanItemVo.getProductName());
                                    activityIntensityMonitor.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                                    activityIntensityMonitor.setTenantCode(TenantUtils.getTenantCode());

                                    activityIntensityMonitorList.add(activityIntensityMonitor);
                                }
                            });
                        }

                        z++;
                    }while (byConditions2 != null && byConditions2.getRecords().size() == 100);

                });
            }
            if(activityIntensityMonitorList.size() >= 100){
                activityIntensityMonitorRepository.saveOrUpdateBatch(activityIntensityMonitorList);
            }
            i++;
        }while (byConditions1 != null && byConditions1.getRecords().size() == 100);

        if(activityIntensityMonitorList.size() > 0){
            activityIntensityMonitorRepository.saveOrUpdateBatch(activityIntensityMonitorList);
        }

    }

    /**
     * 查询产品涉及的方案、细案详情
     * @param monitorType 监控类型
     * @param productCode 产品编码
     * @return
     */
    @Override
    public Page<ProductPromotionItemVo> findItem(Pageable pageable,String monitorType, String productCode,String activityOrgCode,String customerCode,String yearMonthLy,String planCode,String planName) {
        Validate.isTrue(MonitorTypeEnums.contains(monitorType),"未知的监控类型");
        Validate.notBlank(productCode,"产品编码不能为空！");

        Page<ProductPromotionItemVo> productPromotionItemVoList = new Page<>();
        if(MonitorTypeEnums.HEAD_MONITOR.getCode().equals(monitorType)){
            //总部监控
            productPromotionItemVoList = this.findItemFromActivityPlan(pageable,productCode,yearMonthLy,planCode, planName);

        }
        if(MonitorTypeEnums.REGION_MONITOR.getCode().equals(monitorType) || MonitorTypeEnums.CUSTOMER_MONITOR.getCode().equals(monitorType)){
            //大区监控
            ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
            activityDetailPlanItemDto.setProductCode(productCode);
            activityDetailPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            activityDetailPlanItemDto.setTenantCode(TenantUtils.getTenantCode());
            activityDetailPlanItemDto.setDetailPlanCode(planCode);
            activityDetailPlanItemDto.setDetailPlanName(planName);
            activityDetailPlanItemDto.setActivityYearMonth(yearMonthLy);
            if(MonitorTypeEnums.REGION_MONITOR.getCode().equals(monitorType)) {
                activityDetailPlanItemDto.setActivityOrgCode(activityOrgCode);
            } else if(MonitorTypeEnums.CUSTOMER_MONITOR.getCode().equals(monitorType)) {
                activityDetailPlanItemDto.setCustomerCodes(Lists.newArrayList(customerCode));
            }
            productPromotionItemVoList = this.findItemFromActivityDetailPlan(pageable, activityDetailPlanItemDto);
        }

        return productPromotionItemVoList;
    }

    /**
     * 生成活动力度监控表
     *
     * @param yearMonthLy
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void generateActivityIntensityMonitor(String yearMonthLy) {
        if (StringUtils.isBlank(yearMonthLy)) {
            //默认获取上一月的数据
            yearMonthLy = DateUtil.getDateStrByFormat(DateUtil.dateAddMonth(new Date(), -1), DateUtil.DEFAULT_YEAR_MONTH);
        }
        ActivityIntensityMonitorDto dto = new ActivityIntensityMonitorDto();
        dto.setYearMonthLy(yearMonthLy);

        log.info("开始生成活动力度监控【{}】", yearMonthLy);
        log.info("开始生成总部监控");
        dto.setMonitorType(MonitorTypeEnums.HEAD_MONITOR.getCode());
        calculateActivityIntensityMonitor(dto);
        log.info("结束生成总部监控");
        log.info("开始生成大区监控");
        dto.setMonitorType(MonitorTypeEnums.REGION_MONITOR.getCode());
        calculateActivityIntensityMonitor(dto);
        log.info("结束生成大区监控");
        log.info("开始生成客户监控");
        dto.setMonitorType(MonitorTypeEnums.CUSTOMER_MONITOR.getCode());
        calculateActivityIntensityMonitor(dto);
        log.info("结束生成客户监控");
        log.info("完成生成活动力度监控【{}】", yearMonthLy);
    }

    /**
     * 查询细案明细并计算活动力度
     *
     * @param dto
     */
    private void calculateActivityIntensityMonitor(ActivityIntensityMonitorDto dto) {
        List<ActivityIntensityMonitorVO> voList = activityIntensityMonitorRepository.sumActivityDetailPlanItem(dto);
        if (CollectionUtils.isEmpty(voList)) {
            log.error("未找到任意满足条件的细案数据");
            return;
        }
        Set<String> productCodeSet = voList.stream().map(e -> e.getProductCode()).collect(Collectors.toSet());// 产品
        List<ProductVo> productVoList = productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList<>(productCodeSet));
        Validate.notEmpty(productVoList, "未找到任意产品，请检查！");


        //标准价查询
        Map<String, ProductVo> productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        List<List<String>> partition = Lists.partition(new ArrayList<>(productCodeSet), 500);
        List<PriceVo> priceVoList = new ArrayList<>();
        for (List<String> part : partition) {
            priceVoList.addAll(priceVoService.findByProductCodeList(part));
        }
        Validate.notEmpty(priceVoList, "未找到任何产品所对应的价格");
        Map<String, PriceVo> priceVoMap = priceVoList.stream().collect(Collectors.toMap(PriceVo::getGoodsCode, Function.identity(), (o, n) -> o));

        //红线价查询
        List<PriceVo> redPriceVoList = new ArrayList<>();
        for (List<String> part : partition) {
            PriceDto priceDto = new PriceDto();
            priceDto.setTypeCodes(Lists.newArrayList("zthxj"));
            priceDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            priceDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            priceDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            priceDto.setGoodsCodes(part);
            priceDto.setPriceTime(dto.getYearMonthLy()+"-01");
            redPriceVoList.addAll(Optional.ofNullable(this.priceVoService.findByPriceDtoRedLine(priceDto)).orElse(new ArrayList<>()));
        }
        Map<String, PriceVo> redPriceVoMap = redPriceVoList.stream().collect(Collectors.toMap(PriceVo::getGoodsCode, Function.identity(), (o, n) -> o));

        for (ActivityIntensityMonitorVO vo : voList) {
            if (productVoMap.containsKey(vo.getProductCode())) {
                vo.setUnitCode(productVoMap.get(vo.getProductCode()).getBaseUnit());
                vo.setUnit(productVoMap.get(vo.getProductCode()).getBaseUnitDes());
            }
            if (priceVoMap.containsKey(vo.getProductCode())) {
                vo.setStandardPrice(priceVoMap.get(vo.getProductCode()).getPrice());
            }
            vo.setMonitorType(dto.getMonitorType());
            vo.setTenantCode(TenantUtils.getTenantCode());
            vo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            vo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (BigDecimal.ZERO.compareTo(vo.getActivityQty()) < 0) {
                vo.setSuperposedActivityIntensity(vo.getActivityIntensity().divide(vo.getActivityQty(), 4, BigDecimal.ROUND_HALF_UP));
                if (vo.getStandardPrice() != null) {
                    vo.setSuperposedPlanPrice(vo.getStandardPrice().subtract(vo.getSuperposedActivityIntensity()));
                }
            }
            if (redPriceVoMap.containsKey(vo.getProductCode())) {
                BigDecimal redLinePrice = redPriceVoMap.get(vo.getProductCode()).getPrice();
                vo.setRedLinePrice(redLinePrice);
//                2.偏差率计算：=（叠加后规划价-红线价）/红线价
                BigDecimal superposedPlanPrice = Optional.ofNullable(vo.getSuperposedPlanPrice()).orElse(BigDecimal.ZERO);
                vo.setDeviation(superposedPlanPrice.subtract(redLinePrice).divide(redLinePrice, 4, BigDecimal.ROUND_HALF_UP));
            }

        }
        List<ActivityIntensityMonitorVO> tempList = Arrays.asList(new ActivityIntensityMonitorVO[voList.size()]);
        Collections.copy(tempList, voList);
        List<ActivityIntensityMonitorVO> allList = new ArrayList<>();
        Map<String, List<ActivityIntensityMonitorVO>> allMap = tempList.stream().collect(Collectors.groupingBy(ActivityIntensityMonitorVO::getProductCode));
        for (String k : allMap.keySet()) {
            List<ActivityIntensityMonitorVO> list = allMap.get(k);
            ActivityIntensityMonitorVO vo = new ActivityIntensityMonitorVO();
            BeanUtils.copyProperties(list.get(0), vo);
            BigDecimal activityQty = BigDecimal.ZERO;
            BigDecimal activityIntensity = BigDecimal.ZERO;
            for (ActivityIntensityMonitorVO sumVo : list) {
                activityQty = activityQty.add(Optional.ofNullable(sumVo.getActivityQty()).orElse(BigDecimal.ZERO));
                activityIntensity = activityIntensity.add(Optional.ofNullable(sumVo.getActivityIntensity()).orElse(BigDecimal.ZERO));
            }
            vo.setActivityQty(activityQty);
            vo.setActivityIntensity(activityIntensity);
            if (BigDecimal.ZERO.compareTo(vo.getActivityQty()) < 0) {
                vo.setSuperposedActivityIntensity(vo.getActivityIntensity().divide(vo.getActivityQty(), 4, BigDecimal.ROUND_HALF_UP));
                if (vo.getStandardPrice() != null) {
                    vo.setSuperposedPlanPrice(vo.getStandardPrice().subtract(vo.getSuperposedActivityIntensity()));
                }
            }
            vo.setIntensityType(IntensityTypeEnum.ALL.getCode());
            allList.add(vo);
        }
        allList.addAll(voList);

        Collection<ActivityIntensityMonitor> entities = nebulaToolkitService.copyCollectionByWhiteList(allList, ActivityIntensityMonitorVO.class, ActivityIntensityMonitor.class, LinkedHashSet.class, ArrayList.class);
        activityIntensityMonitorRepository.saveBatch(entities);
    }


    /**
     * 查询 产品涉及到的方案明细详情
     * @param pageable 分页对象
     * @param productCode 产品编码
     * @return 明细详情集合
     */
    private Page<ProductPromotionItemVo> findItemFromActivityPlan(Pageable pageable, String productCode,String yearMonthLy,String planCode,String planName) {

        ActivityPlanItemDto activityPlanItemDto = new ActivityPlanItemDto();
        activityPlanItemDto.setProductCode(productCode);
        activityPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityPlanItemDto.setTenantCode(TenantUtils.getTenantCode());
        activityPlanItemDto.setPlanCode(planCode);
        activityPlanItemDto.setPlanName(planName);
        activityPlanItemDto.setActivityYearMonth(yearMonthLy);
        Page<ActivityPlanItemVo> byConditions = activityPlanItemSdkService.findByConditions(pageable, activityPlanItemDto);
        if(byConditions != null && byConditions.getRecords() != null){

            List<ActivityPlanItemVo> activityPlanItemVoList = byConditions.getRecords();
            Set<String> planCodes = activityPlanItemVoList.stream().map(ActivityPlanItemVo::getPlanCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List<ActivityPlanVo> activityPlanVos = activityPlanSdkService.findByPlanCodeList(planCodes);
            Map<String, String> planNameMap = activityPlanVos.stream().collect(Collectors.toMap(ActivityPlanVo::getPlanCode, ActivityPlanVo::getPlanName));
            SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM-dd");

            return (Page<ProductPromotionItemVo>) byConditions.convert(planItem -> {
                ProductPromotionItemVo productPromotionItemVo = new ProductPromotionItemVo();
                productPromotionItemVo.setPlanCode(planItem.getPlanCode());
                productPromotionItemVo.setPlanName(planNameMap.get(planItem.getPlanCode()));
                productPromotionItemVo.setPlanOrgName(planItem.getActivityOrgName());
                productPromotionItemVo.setActivityType(planItem.getActivityTypeCode());
                productPromotionItemVo.setActivityForm(planItem.getActivityFormCode());
                if(planItem.getActivityBeginDate() != null){
                    productPromotionItemVo.setBeginDate(planItem.getActivityBeginDate());
                }
                if(null != planItem.getActivityEndDate()){
                    productPromotionItemVo.setEndDate(planItem.getActivityEndDate());
                }
                productPromotionItemVo.setBudgetItemCode(planItem.getBudgetItemCode());
                productPromotionItemVo.setFirstChannel(planItem.getFirstChannelCode());
                productPromotionItemVo.setSecondChannel(planItem.getSecondChannelCode());
                productPromotionItemVo.setSystem(planItem.getSystemCode());
                BigDecimal feeAmount = planItem.getFeeAmount();
                Integer promoteNumber = planItem.getPromoteNumber();
                productPromotionItemVo.setPromoteNumber(promoteNumber);
                if(feeAmount != null){
                    productPromotionItemVo.setFeeAmount(planItem.getFeeAmount());
                    productPromotionItemVo.setOneFeeAmount(promoteNumber != null && promoteNumber != 0 ? feeAmount.divide(new BigDecimal(promoteNumber),20, RoundingMode.HALF_UP) : null);
                }
                productPromotionItemVo.setCustomerFeeAmount(planItem.getCustomerFeeAmount());
                productPromotionItemVo.setCompanyFeeAmount(planItem.getDepartmentFeeAmount());
                productPromotionItemVo.setAuditConditionCode(planItem.getAuditConditionCode());
                productPromotionItemVo.setFeeRate(planItem.getFeeRate());

                return productPromotionItemVo;
            });
        }
        return new Page<>();
    }

    /**
     * 查询 产品涉及到的细案明细详情
     * @param pageable 分页对象
     * @param activityDetailPlanItemDto 活动细案明细查询条件
     * @return 明细详情集合
     */
    private Page<ProductPromotionItemVo> findItemFromActivityDetailPlan(Pageable
        pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page<ActivityDetailPlanItemVo> byConditions = activityDetailPlanItemSdkService.findByConditions(pageable, activityDetailPlanItemDto);
        if(byConditions != null && byConditions.getRecords() != null){

            List<ActivityDetailPlanItemVo> activityDetailPlanItemVoList = byConditions.getRecords();
            Set<String> detailPlanCodes = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemVo::getDetailPlanCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List<ActivityDetailPlanVo> activityDetailPlanVos = activityDetailPlanSdkService.findByCodes(detailPlanCodes);
            Map<String, String> planNameMap = activityDetailPlanVos.stream().collect(Collectors.toMap(ActivityDetailPlanVo::getDetailPlanCode, ActivityDetailPlanVo::getDetailPlanName));

            return (Page<ProductPromotionItemVo>) byConditions.convert(detailPlanItem -> {
                ProductPromotionItemVo productPromotionItemVo = new ProductPromotionItemVo();
                productPromotionItemVo.setPlanCode(detailPlanItem.getDetailPlanCode());
                productPromotionItemVo.setPlanName(planNameMap.get(detailPlanItem.getDetailPlanCode()));
                productPromotionItemVo.setPlanOrgName(detailPlanItem.getActivityOrgName());
                productPromotionItemVo.setActivityType(detailPlanItem.getActivityType());
                productPromotionItemVo.setActivityForm(detailPlanItem.getActivityForm());
                productPromotionItemVo.setBeginDate(detailPlanItem.getActivityBeginDate());
                productPromotionItemVo.setEndDate(detailPlanItem.getActivityEndDate());
                productPromotionItemVo.setBudgetItemCode(detailPlanItem.getBudgetItemCode());
                productPromotionItemVo.setFirstChannel(detailPlanItem.getFirstChannelCode());
                productPromotionItemVo.setSecondChannel(detailPlanItem.getSecondChannelCode());
                productPromotionItemVo.setSystem(detailPlanItem.getSystemCode());
                BigDecimal feeAmount = detailPlanItem.getFeeAmount();
                Integer promoteNumber = detailPlanItem.getPromoteNumber();
                productPromotionItemVo.setPromoteNumber(promoteNumber);
                if(feeAmount != null){
                    productPromotionItemVo.setFeeAmount(detailPlanItem.getFeeAmount());
                    productPromotionItemVo.setOneFeeAmount(promoteNumber != null && promoteNumber != 0 ? feeAmount.divide(new BigDecimal(promoteNumber),20,RoundingMode.HALF_UP) : null);
                }
                productPromotionItemVo.setCustomerFeeAmount(detailPlanItem.getCustomerFeeAmount());
                productPromotionItemVo.setCompanyFeeAmount(detailPlanItem.getDepartmentFeeAmount());
                productPromotionItemVo.setAuditConditionCode(detailPlanItem.getAuditConditionCode());

                return productPromotionItemVo;
            });
        }
        return new Page<>();
    }


}
