package com.biz.crm.tpm.business.audit.fee.validation.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationInfoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationInfoVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 商超费用结案核销主表
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Slf4j
@RestController
@RequestMapping("/v1/auditFeeValidation/validationVo")
@Api(tags = "业务模块: auditFeeValidationVo: 商超费用结案核销主表")
public class AuditFeeValidationVoController {

  @Resource
  private AuditFeeValidationVoService auditFeeValidationVoService;

  @Resource
  private AuditFeeValidationInfoService auditFeeValidationInfoService;

  /**
   * ID获取详情
   * @param id
   * @return {@link Result}<{@link AuditFeeValidationVo}>
   */
  @ApiOperation(value = "ID获取详情")
  @GetMapping("/findById")
  public Result<AuditFeeValidationVo> findById(@RequestParam(value = "id" , required = false) @ApiParam(name = "id" , value = "主键ID") String id) {
    try {
      AuditFeeValidationVo auditFeeValidationVo = this.auditFeeValidationVoService.findById(id);
      return Result.ok(auditFeeValidationVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 主列表
   * @param pageable
   * @param dto
   * @return {@link Result}<{@link Page}<{@link AuditFeeValidationVo}>>
   */
  @ApiOperation(value = "主列表")
  @GetMapping("/findByConditions")
  public Result<Page<AuditFeeValidationVo>> findByConditions(@PageableDefault(50) Pageable pageable
      , @ApiParam(name = "AuditFeeValidationDto" , value = "参数Dto") AuditFeeValidationDto dto) {
    try {
      Page<AuditFeeValidationVo> page = this.auditFeeValidationVoService.findByConditions(pageable, dto);
      return Result.ok(page);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation("查看核销资料")
  @PostMapping("findAuditInfo")
  public Result<List<AuditFeeValidationInfoVo>> findAuditInfo(@RequestBody AuditFeeValidationDto dto){
    try {

      return Result.ok(this.auditFeeValidationInfoService.findAuditInfo(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
