package com.biz.crm.tpm.business.audit.fee.validation.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;


/**
 * 商超费用结案核销主表
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Getter
@Setter
@Entity
@TableName("tpm_audit_fee_validation_detail")
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AuditFeeValidationDetailEntity" , description = "商超费用结案核销明细表")
@Table(name = "tpm_audit_fee_validation_detail")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_validation_detail" , comment = "商超费用结案核销明细表")
public class AuditFeeValidationDetailEntity extends TenantFlagOpEntity {

    @ApiModelProperty(name = "核销code" , notes = "核销code")
    @Column(name = "audit_code" , length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销code'")
    private String auditCode;

    @ApiModelProperty(name = "核销明细编码" , notes = "核销明细编码")
    @Column(name = "audit_detail_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销明细编码'")
    private String auditDetailCode;

    @ApiModelProperty(name = "差异追踪编码" , notes = "差异追踪编码")
    @Column(name = "plan_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异追踪编码'")
    private String planCode;

    @ApiModelProperty(name = "差异追踪名称" , notes = "差异追踪名称")
    @Column(name = "plan_name" , length = 128, columnDefinition = "VARCHAR(128) COMMENT '差异追踪名称'")
    private String planName;

    @ApiModelProperty(name = "差异追踪明细编码" , notes = "差异追踪明细编码")
    @Column(name = "detail_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异追踪明细编码'")
    private String detailCode;

    @ApiModelProperty(name = "活动类型" , notes = "活动类型")
    @Column(name = "activity_type_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动类型'")
    private String activityTypeCode;

    @ApiModelProperty(name = "活动类型名称" , notes = "活动类型名称")
    @Column(name = "activity_type_name" , length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动类型名称'")
    private String activityTypeName;

    @ApiModelProperty(name = "活动形式" , notes = "活动形式")
    @Column(name = "activity_form_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动形式'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动形式名称" , notes = "活动形式名称")
    @Column(name = "activity_form_name" , length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "活动开始时间" , notes = "活动开始时间")
    @JsonFormat(locale = "zh" , timezone = "GMT+8" , pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "activity_begin_time" , length = 20, columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginTime;

    @ApiModelProperty(name = "活动结束时间" , notes = "活动结束时间")
    @JsonFormat(locale = "zh" , timezone = "GMT+8" , pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Column(name = "activity_end_time" , length = 20, columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndTime;

    @ApiModelProperty("购买方式")
    @Column(name = "buy_way" , length = 32, columnDefinition = "varchar(32) COMMENT '购买方式'")
    private String buyWay;

    @ApiModelProperty("核销类型")
    @Column(name = "audit_type" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '核销类型'")
    private String auditType;

    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code" , length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;

    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name" , length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;

    @ApiModelProperty(name = "核销公式编码" , notes = "核销code")
    @Column(name = "audit_formula_code" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '承接方式'")
    private String auditFormulaCode;

    @ApiModelProperty(name = "核销公式名称" , notes = "核销公式名称")
    @Column(name = "audit_formula_name" , length = 64, columnDefinition = "VARCHAR(64) COMMENT '承接方式'")
    private String auditFormulaName;

    @ApiModelProperty(notes = "销售机构")
    @Column(name = "sales_institution_name" , length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty(notes = "销售机构编码")
    @Column(name = "sales_institution_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty(notes = "销售机构erp编码")
    @Column(name = "sales_institution_erp_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构erp编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty(notes = "销售大区（销售部门）")
    @Column(name = "sales_region_name" , length = 128, columnDefinition = "VARCHAR(128) COMMENT '销售大区'")
    private String salesRegionName;

    @ApiModelProperty(notes = "销售大区编码（销售部门）")
    @Column(name = "sales_region_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售大区编码'")
    private String salesRegionCode;

    @ApiModelProperty("销售组织(销售组，省区)")
    @Column(name = "sales_org_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售组织(销售组，省区)'")
    private String salesOrgCode;

    @ApiModelProperty("销售组织名称(销售组，省区)")
    @Column(name = "sales_org_name" , length = 256, columnDefinition = "VARCHAR(256) COMMENT '销售组织名称(销售组，省区)'")
    private String salesOrgName;

    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @Column(name = "region" , length = 32, columnDefinition = "varchar(32) COMMENT '区域'")
    private String region;

    @ApiModelProperty(name = "系统（零售商）" , notes = "系统")
    @Column(name = "system_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '系统'")
    private String systemCode;

    @ApiModelProperty(name = "系统名称（零售商）" , notes = "系统名称")
    @Column(name = "system_name" , length = 256, columnDefinition = "VARCHAR(256) COMMENT '系统名称'")
    private String systemName;


    /**
     * 一级管理渠道编码
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code" , length = 32, columnDefinition = "varchar(32) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name" , length = 256, columnDefinition = "varchar(256) COMMENT '一级管理渠道名称'")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @Column(name = "second_channel_code" , length = 32, columnDefinition = "varchar(32) COMMENT '二级管理渠道编码'")
    private String secondChannelCode;

    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name" , length = 256, columnDefinition = "varchar(256) COMMENT '二级管理渠道名称'")
    private String secondChannelName;

    @ApiModelProperty(name = "客户" , notes = "客户")
    @Column(name = "customer_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '客户'")
    private String customerCode;

    @ApiModelProperty(name = "客户名称" , notes = "客户名称")
    @Column(name = "customer_name" , length = 128, columnDefinition = "VARCHAR(128) COMMENT '客户名称'")
    private String customerName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    @Column(name = "customer_erp_code" , length = 32, columnDefinition = "varchar(32) COMMENT '客户ERP编码'")
    private String customerErpCode;

    @ApiModelProperty(name = "门店编码" , notes = "门店编码")
    @Column(name = "store_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码'")
    private String storeCode;

    @ApiModelProperty(name = "门店名称" , notes = "门店名称")
    @Column(name = "store_name" , length = 128, columnDefinition = "VARCHAR(128) COMMENT '门店名称'")
    private String storeName;

    /**
     * 品牌编码
     */
    @ApiModelProperty(value = "品牌编码" , notes = "")
    @Column(name = "product_brand_code" , nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品牌编码 '")
    private String productBrandCode;

    /**
     * 品牌名称
     */
    @ApiModelProperty(value = "品牌名称" , notes = "")
    @Column(name = "product_brand_name" , nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品牌名称 '")
    private String productBrandName;

    /**
     * 品类编码
     */
    @ApiModelProperty(value = "品类编码" , notes = "")
    @Column(name = "product_category_code" , nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '品类编码 '")
    private String productCategoryCode;

    /**
     * 品类名称
     */
    @ApiModelProperty(value = "品类名称" , notes = "")
    @Column(name = "product_category_name" , nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '品类名称 '")
    private String productCategoryName;

    /**
     * 产品编码
     */
    @ApiModelProperty(name = "产品编码" , notes = "产品编码")
    @Column(name = "product_code" , nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(name = "产品名称" , notes = "产品名称")
    @Column(name = "product_name" , nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;

    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code" , nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;

    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name" , nullable = true, length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;

    @ApiModelProperty(name = "申请金额" , notes = "申请金额")
    @Column(name = "apply_amount" , columnDefinition = "decimal(24,6) COMMENT '申请金额'")
    private BigDecimal applyAmount;

    @ApiModelProperty(name = "预核销金额（预结案金额）" , notes = "预核销金额")
    @Column(name = "audit_amount" , columnDefinition = "decimal(24,6) COMMENT '预核销金额'")
    private BigDecimal auditAmount;

    @ApiModelProperty(name = "已结案金额" , notes = "已结案金额")
    @Column(name = "already_audit_amount" , columnDefinition = "decimal(24,6) COMMENT '已结案金额'")
    private BigDecimal alreadyAuditAmount;

    @ApiModelProperty(name = "本次结案金额" , notes = "本次结案金额")
    @Column(name = "this_audit_amount" , columnDefinition = "decimal(24,6) COMMENT '本次结案金额'")
    private BigDecimal thisAuditAmount;

    @ApiModelProperty(name = "是否完全结案" , notes = "是否完全结案")
    @Column(name = "whole_audit" , length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String wholeAudit;

    @ApiModelProperty("是否逾期")
    @Column(name = "overdue" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '是否逾期'")
    private String overdue;

    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code" , length = 32, columnDefinition = "VARCHAR(32) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name" , length = 255, columnDefinition = "VARCHAR(255) COMMENT '门店名称'")
    private String terminalName;

}
