package com.biz.crm.tpm.business.audit.fee.validation.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 商超费用结案核销主表
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Getter
@Setter
@Entity
@TableName("tpm_audit_fee_validation_info_attachment")
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "AuditFeeValidationInfoAttachmentEntity", description = "核销资料附件")
@Table(name = "tpm_audit_fee_validation_info_attachment")
@org.hibernate.annotations.Table(appliesTo = "tpm_audit_fee_validation_info_attachment", comment = "核销资料附件")
public class AuditFeeValidationInfoAttachmentEntity extends TenantFlagOpEntity {
    @ApiModelProperty(name = "核销code", notes = "核销code")
    @Column(name = "audit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销code'")
    private String auditCode;

    @ApiModelProperty(name = "核销资料id", notes = "核销资料id")
    @Column(name = "audit_info_id",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销资料id'")
    private String auditInfoId;

    @ApiModelProperty(value = "文件唯一识别号")
    @Column(name = "file_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '文件唯一识别号'")
    private String fileCode;

    /**
     * 原始文件名
     */
    @ApiModelProperty(name="originalFileName" , value="原始文件名")
    @Column(name = "original_file_name",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '原始文件名'")
    private String originalFileName;
}
