package com.biz.crm.tpm.business.audit.fee.validation.local.exports;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.biz.crm.common.ie.sdk.excel.process.ExportProcess;
import com.biz.crm.common.ie.sdk.vo.ExportTaskProcessVo;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.constant.CommonConstant;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateExportVo;
import liquibase.util.Validate;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Component
public class AuditFeeValidationDetailUpdateExportsProcess implements ExportProcess<AuditFeeValidationDetailUpdateExportVo> {

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private AuditFeeValidationDetailVoService auditFeeValidationDetailVoService;


    @Override
    public Integer getPageSize() {
        return CommonConstant.IE_EXPORT_MAX_TOTAL;
    }

    @Override
    public Integer getTotal(Map<String, Object> params) {
        String cacheKey = getCacheKey(params);
        Integer total = auditFeeValidationDetailVoService.getExportTotal(cacheKey);
        Validate.isTrue(total < CommonConstant.IE_EXPORT_MAX_TOTAL, "导出时,单次最大导出[" + CommonConstant.IE_EXPORT_MAX_TOTAL + "]条,请输入更多查询条件!!");
        return total;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        Validate.notNull(cacheKey, "缓存可以不能为空");
        return (String) cacheKey;
    }

    @Override
    public JSONArray getData(ExportTaskProcessVo vo, Map<String, Object> params) {
        String cacheKey = getCacheKey(params);
        List<AuditFeeValidationDetailUpdateExportVo> result = auditFeeValidationDetailVoService.getExportData(cacheKey);
        /*Map<String, List<DictDataVo>> mapDict = this.dictDataVoService.findByDictTypeCodeList(Lists.newArrayList(AuditConstant.TPM_AUDIT_FORM,
                AuditConstant.YES_OR_NO, AuditConstants.PURCHASE_METHOD, AuditConstants.TPM_PAY_TYPE, AuditConstant.CUSTOMER_SUPPLIER, AuditConstant.AUDIT_TYPE));*/
        for (AuditFeeValidationDetailUpdateExportVo detailExportsVo : result) {
            /*detailExportsVo.setCustomerSupplierType(findDictValue(mapDict, AuditConstant.CUSTOMER_SUPPLIER, String.valueOf(detailExportsVo.getCustomerSupplierType())));
            detailExportsVo.setAuditType(TpmAuditTypeEnum.getDescByCode(detailExportsVo.getAuditType()));
            detailExportsVo.setOverdue(findDictValue(mapDict, AuditConstant.YES_OR_NO, String.valueOf(detailExportsVo.getOverdue())));
            detailExportsVo.setAuditWay(findDictValue(mapDict, AuditConstant.AUDIT_TYPE, String.valueOf(detailExportsVo.getAuditWay())));
            detailExportsVo.setAssociationType(findDictValue(mapDict, AuditConstant.TPM_SUB_COM_ACTIVITY_ASSOCIATION_TYPE, String.valueOf(detailExportsVo.getAssociationType())));
            detailExportsVo.setUndertakingMode(findDictValue(mapDict, AuditConstant.ACCEPT_TYPE, String.valueOf(detailExportsVo.getUndertakingMode())));*/
        }
        return JSON.parseArray(JSON.toJSONString(result));
    }

    /**
     * 获取字典值
     * @param mapDict
     * @param dictTypeCode
     * @param code
     * @return
     */
    private String findDictValue(Map<String, List<DictDataVo>> mapDict, String dictTypeCode, String code) {
        if (Objects.isNull(mapDict) || StringUtils.isBlank(dictTypeCode) || StringUtils.isBlank(code)) {
            return StringUtils.EMPTY;
        }
        final List<DictDataVo> vos = mapDict.get(dictTypeCode);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(vos)) {
            return StringUtils.EMPTY;
        }
        final Optional<String> first =
                vos.stream()
                        .filter(a -> a.getDictCode().equals(code))
                        .map(DictDataVo::getDictValue)
                        .findFirst();
        return first.orElse(StringUtils.EMPTY);
    }

    @Override
    public Class<AuditFeeValidationDetailUpdateExportVo> findCrmExcelVoClass() {
        return AuditFeeValidationDetailUpdateExportVo.class;
    }

    @Override
    public String getBusinessCode() {
        return "audit_fee_validation_detail_export";
    }

    @Override
    public String getBusinessName() {
        return "差异结案明细导出编辑";
    }
}
