package com.biz.crm.tpm.business.audit.fee.validation.local.imports;

import cn.hutool.json.JSONUtil;
import com.biz.crm.common.ie.sdk.excel.process.ImportProcess;
import com.biz.crm.common.ie.sdk.vo.TaskGlobalParamsVo;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationDetailVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUpdateImportVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Component
@Slf4j
public class AuditFeeValidationDetailUpdateImportsProcess implements ImportProcess<AuditFeeValidationDetailUpdateImportVo> {

    @Autowired(required = false)
    private AuditFeeValidationDetailVoService auditFeeValidationDetailVoService;


    @Override
    public Integer getBatchCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    public Map<Integer, String> execute(LinkedHashMap<Integer, AuditFeeValidationDetailUpdateImportVo> data, TaskGlobalParamsVo paramsVo, Map<String, Object> params) {
        log.info("导入参数++++++:[{}],[{}]", params, JSONUtil.toJsonStr(data.values()));
        String cacheKey = getCacheKey(params);

        List<AuditFeeValidationDetailDto> result;
        Map<String, String> errorMap = Maps.newHashMap();
        try {
            if (data.values().isEmpty()) {
                throw new IllegalArgumentException("导入的数据为空");
            }
            List<AuditFeeValidationDetailUpdateImportVo> importsVoList = Lists.newArrayList(data.values());
            result = this.auditFeeValidationDetailVoService.validate(importsVoList, cacheKey, errorMap);
            if (0 == errorMap.size()) {
                log.info("验证成功数据: {}", JSONUtil.toJsonStr(result));
                this.auditFeeValidationDetailVoService.imports(cacheKey, result);
            }
        } catch (Exception e) {
            log.error("差异费用结案导入异常信息", e);
            throw new IllegalArgumentException(e.getMessage());
        }
        Map<Integer, String> resultErrorMap = new HashMap<>();
        data.forEach((key, value) -> {
            String msg = errorMap.get(value.getId());
            if (StringUtils.isNotEmpty(msg)) {
                msg = "第" + (key + 1) + "行" + msg;
                resultErrorMap.put(key, msg);
            }
        });
        return resultErrorMap;
    }

    private String getCacheKey(Map<String, Object> params) {
        Object cacheKey = params.get("cacheKey");
        liquibase.util.Validate.notNull(cacheKey, "缓存key不能为空");
        return (String) cacheKey;
    }

    @Override
    public Class<AuditFeeValidationDetailUpdateImportVo> findCrmExcelVoClass() {
        return AuditFeeValidationDetailUpdateImportVo.class;
    }

    @Override
    public String getTemplateCode() {
        return "audit_fee_validation_detail_update_import";
    }

    @Override
    public String getTemplateName() {
        return "差异结案明细导入编辑";
    }


}
