package com.biz.crm.tpm.business.audit.fee.validation.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.mapper.AuditFeeValidationDetailMapper;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Description 明细
 * @Author wei·yang
 * @Date Created in 2023/9/27 15:52
 */
@Component
public class AuditFeeValidationDetailRepository extends ServiceImpl<AuditFeeValidationDetailMapper, AuditFeeValidationDetailEntity> {


    public List<AuditFeeValidationDetailEntity> findByAuditCode(String auditCode){
        if(StringUtils.isEmpty(auditCode)){
            return Lists.newArrayList();
        }
        return this.lambdaQuery().eq(AuditFeeValidationDetailEntity::getAuditCode,auditCode)
                .eq(AuditFeeValidationDetailEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeValidationDetailEntity::getTenantCode, TenantUtils.getTenantCode())
                .list();
    }

    /**
     * 删除明细
     * @param auditCode
     */
    public void deleteByAuditCode(String auditCode) {
        this.lambdaUpdate().eq(AuditFeeValidationDetailEntity::getAuditCode, auditCode).remove();
    }

    public List<AuditFeeValidationDetailDto> findInApprovalValidation(String id, String auditCode, String processStatus, String tenantCode) {
        return this.baseMapper.findInApprovalValidationByAuditCode(id,auditCode,processStatus,tenantCode);
    }

    public List<AuditFeeValidationDetailDto> findInApprovalValidation(String id,List<String> detailCodes,String processStatus, String tenantCode) {
        return this.baseMapper.findInApprovalValidationByDetailCodes(id,detailCodes,processStatus,tenantCode);
    }
}
