package com.biz.crm.tpm.business.audit.fee.validation.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailUseLedgerEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.mapper.AuditFeeValidationDetailUseLedgerMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @Description:
 * @Author qiancheng
 * @Date 2023/11/22
 */
@Component
public class AuditFeeValidationDetailUseLedgerRepository extends ServiceImpl<AuditFeeValidationDetailUseLedgerMapper, AuditFeeValidationDetailUseLedgerEntity> {


    public List<AuditFeeValidationDetailUseLedgerEntity> findByAuditDetailCodes(List<String> auditDetailCodes) {
        return this.lambdaQuery()
                .eq(AuditFeeValidationDetailUseLedgerEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeValidationDetailUseLedgerEntity::getTenantCode, TenantUtils.getTenantCode())
                .eq(AuditFeeValidationDetailUseLedgerEntity::getIsReturned, BooleanEnum.FALSE.getCapital())
                .in(AuditFeeValidationDetailUseLedgerEntity::getAuditDetailCode,auditDetailCodes)
                .list();
    }

    public void updateIsReturned(List<String> idList, String isReturned) {
        if (CollectionUtils.isEmpty(idList) || StringUtils.isBlank(isReturned)) {
            return;
        }
        this.lambdaUpdate()
                .set(AuditFeeValidationDetailUseLedgerEntity::getIsReturned,isReturned)
                .eq(AuditFeeValidationDetailUseLedgerEntity::getDelFlag,DelFlagStatusEnum.NORMAL.getCode())
                .eq(AuditFeeValidationDetailUseLedgerEntity::getTenantCode,TenantUtils.getTenantCode())
                .in(AuditFeeValidationDetailUseLedgerEntity::getId,idList)
                .update();
    }
}
