package com.biz.crm.tpm.business.audit.fee.validation.local.service;

import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationDetailEntity;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailDto;

import java.util.List;

/**
 * @Description 明细VoService
 * @Author wei·yang
 * @Date Created in 2023/9/27 15:30
 */
public interface AuditFeeValidationDetailService{

    /**
     * 保存明细
     * @param auditCode
     * @param isEdit
     * @param cacheKey
     * @return {@link List}<{@link AuditFeeValidationDetailDto}>
     */
    List<AuditFeeValidationDetailDto> createOrUpdate(String auditCode, boolean isEdit, String cacheKey,String saveType);

    void addItemCache(String cacheKey, List<AuditFeeValidationDetailDto> detailDtos);

    /**
     * 根据auditCode找到明细
     * @param auditCode
     * @return
     */
    List<AuditFeeValidationDetailEntity> findByAuditCode(String auditCode);

    /**
     * 找到明细中，关联了相同差异追踪明细切状态还是‘审批中’的数据
     * @param auditCode
     * @param auditDetailCodes
     * @param processStatus
     * @return
     */
    List<AuditFeeValidationDetailDto> findInApprovalValidation(String id ,String auditCode,List<String> auditDetailCodes,String processStatus);
}
