package com.biz.crm.tpm.business.audit.fee.validation.local.service;

import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDetailUseLedgerDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationDetailUseLedgerVo;

import java.util.List;

/**
 * @Description:抵扣台账记录
 * @Author qiancheng
 * @Date 2023/11/22
 */
public interface AuditFeeValidationDetailUseLedgerService {

    /**
     * 差异结案提交审批，超额抵扣差异台账，生成抵扣记录
     * @param dtoList
     */
    void saveBatch(List<AuditFeeValidationDetailUseLedgerDto> dtoList);

    /**
     * 更据差异结案明细编码查询抵扣记录详情
     * @param auditDetailCodes
     * @return
     */
    List<AuditFeeValidationDetailUseLedgerVo> findByAuditDetailCodes(List<String> auditDetailCodes);

    /**
     * 差异结案审批驳回、追回，更据抵扣记录回退台账金额后，更新已回退标记
     * @param idList
     * @param isReturned
     */
    void updateIsReturned(List<String> idList, String isReturned);
}
