package com.biz.crm.tpm.business.audit.fee.validation.local.service;

import com.biz.crm.tpm.business.audit.fee.sdk.dto.ledger.AuditFeeDiffLedgerDeductionDto;
import com.biz.crm.tpm.business.audit.fee.sdk.dto.track.AuditFeeDiffTrackDetailDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.security.sdk.login.UserIdentity;

import java.util.List;

/**
 * 商超费用结案核销主表 内部接口
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
public interface AuditFeeValidationService {

  /**
   * 新增
   * @param params
   */
  void createOrUpdate(AuditFeeValidationDto dto);

  /**
   * 删除
   * @param params
   */
  void deleteBatch(List<String> ids);

  /**
   * 启用
   * @param params
   * @return
   */
  void enableBatch(List<String> ids);

  /**
   * 禁用
   * @param params
   * @return
   */
  void disableBatch(List<String> ids);

    void submitApproval(AuditFeeValidationDto dto);

    void batchRelevance(UserIdentity loginUser, AuditFeeDiffTrackDetailDto dto);

  /**
   * 操作台账
   * @param currentOperateId 本次操作实例id
   * @param operateDto
   */
  void operateAmount(String currentOperateId, List<AuditFeeDiffLedgerDeductionDto> operateDto);

    void updateProcessStatusByAuditCode(String auditCode, ProcessStatusEnum statusEnum, String processNo);

  AuditFeeValidationVo findConditionByAuditCode(String auditCode);
}

