package com.biz.crm.tpm.business.audit.fee.validation.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.audit.fee.validation.local.entity.AuditFeeValidationEntity;
import com.biz.crm.tpm.business.audit.fee.validation.local.repository.AuditFeeValidationRepository;
import com.biz.crm.tpm.business.audit.fee.validation.local.service.AuditFeeValidationInfoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.dto.AuditFeeValidationDto;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.service.AuditFeeValidationVoService;
import com.biz.crm.tpm.business.audit.fee.validation.sdk.vo.AuditFeeValidationVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;


/**
 * 商超费用结案核销主表 外部接口实现
 *
 * @author weiÂ·yang
 * @date 2023-09-26 17:23:21
 */
@Slf4j
@Service("auditFeeValidationVoService")
public class AuditFeeValidationVoServiceImpl implements AuditFeeValidationVoService {

  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  @Resource
  private AuditFeeValidationRepository auditFeeValidationRepository;

  @Resource
  private AuditFeeValidationInfoService auditFeeValidationInfoService;

  /**
   * ID获取详情
   * @param id
   * @return {@link AuditFeeValidationVo}
   */
  @Override
  public AuditFeeValidationVo findById(String id) {
    Assert.hasText(id, "主键ID不能为空");
    AuditFeeValidationEntity entity = this.auditFeeValidationRepository.getById(id);
    Assert.notNull(entity, "未查询到数据信息");
    AuditFeeValidationVo auditFeeValidationVo = this.nebulaToolkitService
        .copyObjectByWhiteList(entity, AuditFeeValidationVo.class, HashSet.class, ArrayList.class);
    //查询核销资料
    auditFeeValidationVo.setAuditInfoList(this.auditFeeValidationInfoService.findByAuditCode(entity.getAuditCode()));
    return auditFeeValidationVo;
  }

  /**
   * 主列表
   * @param pageable
   * @param dto
   * @return {@link Page}<{@link AuditFeeValidationVo}>
   */
  @Override
  public Page<AuditFeeValidationVo> findByConditions(Pageable pageable, AuditFeeValidationDto dto) {
    pageable = Optional.ofNullable(pageable).orElse(PageRequest.of(0, 50));
    return this.auditFeeValidationRepository.findByConditions(pageable, dto);
  }

  @Override
  public List<String> findProcessStatusNotPass(List<String> detailCodeList) {
    return auditFeeValidationRepository.findProcessStatusNotPass(detailCodeList);
  }
}
