package com.biz.crm.tpm.business.budget.forecast.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.forecast.feign.feign.internal.SubComBudgetForecastFeignImpl;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年12月13日 10:43
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = SubComBudgetForecastFeignImpl.class)
public interface SubComBudgetForecastFeign {

    /**
     * 分页查询分子公司预算预测
     *
     * @param pageable
     * @param dto
     * @return com.biz.crm.business.common.sdk.model.Result<com.baomidou.mybatisplus.extension.plugins.pagination.Page < com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo>>
     * @author huojia
     * @date 2022/12/13 10:54
     **/
    @GetMapping("/v1/budget/forecast/subsidiary/findByConditions")
    Result<Page<SubComBudgetForecastVo>> findByConditions(Pageable pageable, SubComBudgetForecastDto dto);

    /**
     * 条件查询分子公司预算预测
     *
     * @param subComBudgetForecastDto
     * @return com.biz.crm.business.common.sdk.model.Result<java.util.List < com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo>>
     * @author huojia
     * @date 2022/12/13 10:54
     **/
    @PostMapping("/v1/budget/forecast/subsidiary/listByConditions")
    Result<List<SubComBudgetForecastVo>> listByConditions(@RequestBody SubComBudgetForecastDto subComBudgetForecastDto);

    /**
     * 操作分子公司预算预测
     *
     * @param subComBudgetForecastDtoList
     * @return com.biz.crm.business.common.sdk.model.Result
     * @author huojia
     * @date 2022/12/13 11:14
     **/
    @PostMapping("/v1/budget/forecast/subsidiary/operationBudgetForecast")
    Result operationBudgetForecast(@RequestBody List<SubComBudgetForecastDetailDto> subComBudgetForecastDtoList);

    /**
     * 查询税金及其附加
     *
     * @param subComBudgetForecastVo
     * @return com.biz.crm.business.common.sdk.model.Result<java.math.BigDecimal>
     * @author huojia
     * @date 2022/12/13 10:55
     **/
    @PostMapping("/v1/budget/forecast/subsidiary/queryTaxAndAddition")
    Result<BigDecimal> queryTaxAndAddition(@RequestBody SubComBudgetForecastVo subComBudgetForecastVo);
}
