package com.biz.crm.tpm.business.budget.forecast.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.forecast.feign.feign.BudgetForecastFeign;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.BudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

/**
 * @author huojia
 * @date 2022年12月13日 10:25
 */
@Slf4j
@Component
public class BudgetForecastFeignImpl implements FallbackFactory<BudgetForecastFeign> {

    @Override
    public BudgetForecastFeign create(Throwable throwable) {
        log.error("进入BudgetForecastFeign熔断", throwable);
        return new BudgetForecastFeign() {
            @Override
            public Result<Page<BudgetForecastVo>> findByConditions(Pageable pageable, BudgetForecastDto dto) {
                throw new UnsupportedOperationException("分页查询预算预测熔断");
            }
        };
    }

}
