package com.biz.crm.tpm.business.budget.forecast.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.forecast.feign.feign.BudgetForecastFeign;
import com.biz.crm.tpm.business.budget.forecast.feign.feign.SubComBudgetForecastFeign;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDetailDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年12月13日 10:45
 */
@Slf4j
@Component
public class SubComBudgetForecastFeignImpl implements FallbackFactory<SubComBudgetForecastFeign> {
    @Override
    public SubComBudgetForecastFeign create(Throwable throwable) {
        log.error("进入SubComBudgetForecastFeign熔断", throwable);
        return new SubComBudgetForecastFeign() {
            @Override
            public Result<Page<SubComBudgetForecastVo>> findByConditions(Pageable pageable, SubComBudgetForecastDto dto) {
                throw new UnsupportedOperationException("分页查询预算预测熔断");
            }

            @Override
            public Result<List<SubComBudgetForecastVo>> listByConditions(SubComBudgetForecastDto subComBudgetForecastDto) {
                throw new UnsupportedOperationException("条件查询预算预测熔断");
            }

            @Override
            public Result operationBudgetForecast(List<SubComBudgetForecastDetailDto> subComBudgetForecastDtoList) {
                throw new UnsupportedOperationException("操作预算预测熔断");
            }

            @Override
            public Result<BigDecimal> queryTaxAndAddition(SubComBudgetForecastVo subComBudgetForecastVo) {
                throw new UnsupportedOperationException("查询税金及其附加预测熔断");
            }
        };
    }
}
