package com.biz.crm.tpm.business.budget.forecast.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.budget.forecast.feign.feign.BudgetForecastFeign;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.BudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.service.BudgetForecastService;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年12月13日 10:19
 */
@Slf4j
@Service
public class BudgetForecastServiceImpl implements BudgetForecastService {

    @Resource
    private BudgetForecastFeign budgetForecastFeign;

    @Override
    public Page<BudgetForecastVo> findByConditions(Pageable pageable, BudgetForecastDto dto) {
        Result<Page<BudgetForecastVo>> result = budgetForecastFeign.findByConditions(pageable, dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public void importSave(List<BudgetForecastDto> importList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void delete(List<String> ids) {
        throw new UnsupportedOperationException();
    }

}
