package com.biz.crm.tpm.business.budget.forecast.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 15:26
 */
@ApiModel(value = "SubComBudgetForecastDto", description = "TPM-分子预算预测")
@Getter
@Setter
public class SubComAutoDetailDto extends TenantFlagOpDto {

    /**
     * 分子公司预算预测编码
     */
    @ApiModelProperty(value = "分子公司预算预测编码")
    private String budgetForecastCode;

    /**
     * 理论收入
     */
    @ApiModelProperty("理论收入")
    private BigDecimal theoryIncome;

    /**
     * 理论成本
     */
    @ApiModelProperty("理论成本")
    private BigDecimal theoryCost;

    /**
     * 理论毛利
     */
    @ApiModelProperty("理论毛利")
    private BigDecimal theoryProfit;

    /**
     * 固定支出小计
     */
    @ApiModelProperty("固定支出小计")
    private BigDecimal fixedPayTotal;

    /**
     * 利润目标
     */
    @ApiModelProperty("利润目标")
    private BigDecimal profitGoal;

    /**
     * 考核扣款
     */
    @ApiModelProperty("考核扣款")
    private BigDecimal assessDeduction;

    /**
     * 税金及附加
     */
    @ApiModelProperty("税金及附加")
    private BigDecimal taxAmount;

    /**
     * 自投费用
     */
    @ApiModelProperty("自投费用")
    private BigDecimal autoAmount;

    /**
     * 核准金额
     */
    @ApiModelProperty("核准金额")
    private BigDecimal approvedAmount;

    /**
     * 核准金额字符串
     */
    @ApiModelProperty("核准金额字符串")
    private String approvedAmountStr;

}
