package com.biz.crm.tpm.business.budget.forecast.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 15:26
 */
@ApiModel(value = "SubComBudgetForecastDto", description = "TPM-分子预算预测")
@Getter
@Setter
public class SubComBudgetForecastDto extends TenantFlagOpDto {

    /**
     * 分子公司预算预测编码
     */
    @ApiModelProperty(value = "分子公司预算预测编码")
    private String budgetForecastCode;

    @ApiModelProperty(value = "分子公司预算预测编码(排除)")
    private String excludeCode;

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    /**
     * 年月
     */
    @ApiModelProperty(value = "年月")
    private String yearMonthLy;

    /**
     * 年月集合
     */
    @ApiModelProperty(value = "年月集合")
    private List<String> yearMonthList;

    /**
     * 组织编码
     */
    @ApiModelProperty(value = "组织编码")
    private String orgCode;

    @ApiModelProperty("orgCodeList")
    private List<String> orgCodeList;

    /**
     * 组织名称
     */
    @ApiModelProperty(value = "销售组织名称")
    private String orgName;

    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称")
    private String budgetItemName;

    /**
     * 费用来源[数据字典:tpm_fee_source]
     */
    @ApiModelProperty(value = "费用来源[数据字典:tpm_fee_source]")
    private String feeSourceCode;

    /**
     * 预算金额
     */
    @ApiModelProperty("预算金额")
    private BigDecimal budgetAmount;

    /**
     * 核准金额
     */
    @ApiModelProperty("核准金额")
    private BigDecimal approvedAmount;

    /**
     * 已使用金额
     */
    @ApiModelProperty("已使用金额")
    private BigDecimal usedAmount;

    /**
     * 剩余金额
     */
    @ApiModelProperty("剩余金额")
    private BigDecimal remainderAmount;

    /**
     * 已规划金额（分子公司活动规划时使用）
     */
    @ApiModelProperty("已规划金额（分子公司活动规划时使用）")
    private BigDecimal designAmount;

    /**
     * 本次规划金额（分子公司活动规划时使用）
     */
    @ApiModelProperty("本次规划金额（分子公司活动规划时使用）")
    private BigDecimal thisDesignAmount;

    @ApiModelProperty("数据来源")
    private String dataSourceCode;

    @ApiModelProperty("期初完全承接金额")
    private BigDecimal firstWholeUndertakeAmt;

    @ApiModelProperty("期初部分承接金额")
    private BigDecimal firstPartUndertakeAmt;

    @ApiModelProperty("剩余完全承接金额")
    private BigDecimal surplusWholeUndertakeAmt;

    @ApiModelProperty("剩余部分承接金额")
    private BigDecimal surplusPartUndertakeAmt;

    @ApiModelProperty("已向上申请金额")
    private BigDecimal applyAmountUp;

    @ApiModelProperty("调整金额")
    private BigDecimal adjustAmount;

    @ApiModelProperty("冻结金额")
    private BigDecimal freezeAmount;

    @ApiModelProperty("期初预算金额")
    private BigDecimal firstBudgetAmount;

    /**
     * 销售公司代码
     */
    @ApiModelProperty(name = "salesCompanyCode", value = "销售公司代码", notes = "销售公司代码")
    private String salesCompanyCode;

    /**
     * 销售公司代码
     */
    @ApiModelProperty(name = "salesCompanyName", value = "销售公司名称", notes = "销售公司名称")
    private String salesCompanyName;

    /**
     * 流程编号
     */
    @ApiModelProperty(name = "processNo", value = "流程编号", notes = "流程编号")
    private String processNo;

    /**
     * 审批状态
     */
    @ApiModelProperty(name = "processStatus", value = "审批状态", notes = "审批状态")
    private String processStatus;

    /**
     * 审批时间
     */
    @ApiModelProperty(name = "processTime", value = "审批时间", notes = "审批时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date processTime;

    @ApiModelProperty("查询使用，预算项目编码")
    private List<String> budgetItemCodeList;
}
