package com.biz.crm.tpm.business.budget.forecast.sdk.dto;

import com.biz.crm.workflow.sdk.dto.ProcessBusinessDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * 分子公司预算预测变更
 */
@ApiModel(value = "SubComBudgetForecastOperateDto", description = "TPM-分子公司预算预测变更")
@Getter
@Setter
public class SubComBudgetForecastOperateDto {

    @ApiModelProperty(value = "分子公司预算预测编码")
    private String budgetForecastCode;

    @ApiModelProperty(value = "操作金额")
    private BigDecimal operationAmount;

    @ApiModelProperty(value = "操作类型")
    private String operationType;

    @ApiModelProperty(value = "操作说明")
    private String operationRemarks;

    @ApiModelProperty("工作流参数")
    private ProcessBusinessDto processBusiness;
}