package com.biz.crm.tpm.business.budget.forecast.sdk.enums;

import lombok.Getter;

/**
 * @author huojia
 * @date 2022年11月18日 10:52
 */
@Getter
public enum ForecastOperationTypeEnum {

    /**
     * 期初
     */
    INIT("init", "期初"),

    /**
     * 使用
     */
    USE("use", "使用"),

    /**
     * 退回
     */
    RETURN("return", "退回"),

    /**
     * 变更
     */
    CHANGE("change", "变更"),

    /**
     * 核准
     */
    APPROVED_AMOUNT("approved_amount", "核准"),

    AUDIT_USE("audit_use","核销使用"),

    AUDIT_RETURN("audit_return","核销退回"),

    /**
     * 考核扣减
     */
    EXAMINE_CIRCULAR_SUBTRACT("examine_circular_subtract", "考核扣款"),

    /**
     * 考核奖励
     */
    EXAMINE_CIRCULAR_ADD("examine_circular_add", "考核奖励"),

    ;

    private String code;

    private String desc;

    ForecastOperationTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

}
