package com.biz.crm.tpm.business.budget.forecast.sdk.event;

import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author huojia
 * @date 2022年10月28日 17:38
 */
public interface SubComBudgetForecastLogEventListener extends NebulaEvent {

    /**
     * 创建预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onCreate(SubComBudgetForecastLogEventDto dto);

    /**
     * 删除预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDelete(SubComBudgetForecastLogEventDto dto);

    /**
     * 修改预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onUpdate(SubComBudgetForecastLogEventDto dto);

    /**
     * 启用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onEnable(SubComBudgetForecastLogEventDto dto);

    /**
     * 禁用预算项目事件
     *
     * @param dto
     * @author huojia
     * @date 2022/10/24 17:10
     **/
    void onDisable(SubComBudgetForecastLogEventDto dto);
}
