package com.biz.crm.tpm.business.budget.forecast.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.BudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.SubComBudgetForecastDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastVo;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月27日 15:21
 */
public interface BudgetForecastService {

    /**
     * 分页查询
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastVo>
     * @author huojia
     * @date 2022/10/27 15:35
     **/
    Page<BudgetForecastVo> findByConditions(Pageable pageable, BudgetForecastDto dto);

    /**
     * 批量导入新增
     *
     * @param importList
     * @author huojia
     * @date 2022/10/28 17:30
     **/
    void importSave(List<BudgetForecastDto> importList);

    /**
     * 根据id批量删除
     *
     * @param ids
     * @author huojia
     * @date 2022/11/5 21:05
     **/
    void delete(List<String> ids);

}
