package com.biz.crm.tpm.business.budget.forecast.sdk.service;

import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 分子预算预测加锁
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023-12-12 22:47
 */
public interface SubComBudgetForecastLockService {

    /**
     * 根据预算预测编码加锁
     *
     * @param budgetForecastCode
     * @param timeUnit
     * @param time
     * @return boolean
     * @author huojia
     * @date 2022/11/1 14:21
     **/
    boolean lock(String budgetForecastCode, TimeUnit timeUnit, int time);

    /**
     * 根据预算预测编码批量加锁
     *
     * @param budgetForecastCodeList
     * @param timeUnit
     * @param time
     * @return boolean
     * @author huojia
     * @date 2022/11/1 14:21
     **/
    boolean lock(List<String> budgetForecastCodeList, TimeUnit timeUnit, int time);

    /**
     * 根据预算预测编码批量加锁
     *
     * @param budgetForecastCodeList
     * @param timeUnit
     * @param lockTime
     * @param waiteTime
     * @return boolean
     * @author huojia
     * @date 2022/11/1 14:21
     **/
    boolean lock(List<String> budgetForecastCodeList, TimeUnit timeUnit, int lockTime, int waiteTime);

    /**
     * 解锁
     *
     * @param budgetForecastCode
     * @author huojia
     * @date 2022/11/1 14:46
     **/
    void unLock(String budgetForecastCode);

    /**
     * 批量解锁
     *
     * @param budgetForecastCodeList
     * @author huojia
     * @date 2022/11/1 14:46
     **/
    void unLock(List<String> budgetForecastCodeList);

}
