package com.biz.crm.tpm.business.budget.forecast.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.budget.forecast.sdk.dto.*;
import com.biz.crm.tpm.business.budget.forecast.sdk.vo.*;
import com.biz.crm.tpm.business.profit.goal.discount.sdk.dto.ProfitGoalDiscountDto;
import com.google.common.collect.Lists;
import org.springframework.data.domain.Pageable;

import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * @author huojia
 * @date 2022年10月27日 15:21
 */
public interface SubComBudgetForecastService {

    /**
     * 分页查询
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.tpm.business.budget.forecast.sdk.vo.BudgetForecastVo>
     * @author huojia
     * @date 2022/10/27 15:35
     **/
    Page<SubComBudgetForecastVo> findByConditions(Pageable pageable, SubComBudgetForecastDto dto);

    /**
     * 根据分子公司预算配置批量编辑
     *
     * @param profitGoalDiscountDtoList
     * @author huojia
     * @date 2022/11/19 16:41
     **/
    void updateByConfigBatch(List<ProfitGoalDiscountDto> profitGoalDiscountDtoList);

    /**
     * 根据分子公司预算配置，批量新增
     *
     * @param profitGoalDiscountDtoList
     * @return java.lang.String
     * @author huojia
     * @date 2022/11/19 16:41
     **/
    String saveByConfigBatch(List<ProfitGoalDiscountDto> profitGoalDiscountDtoList);

    /**
     * 没有对应预算配置数据，则直接初始化
     *
     * @param budgetForecastCode
     * @author huojia
     * @date 2022/11/19 18:09
     **/
    void initByCode(String budgetForecastCode);

    /**
     * 按年月计算点内数据
     *
     * @param yearMonth
     * @author huojia
     * @date 2022/11/22 10:17
     **/
    void manualInternalData(String yearMonth);

    /**
     * 根据年月计算点内费用
     *
     * @param yearMonth
     * @author huojia
     * @date 2022/11/22 10:45
     **/
    void calInternalData(String yearMonth);

    /**
     * 根据年月计算点内费用(按照点外方式生成，通过细案生成)
     *
     * @param yearMonth
     * @author chenlong
     * @date 2023/05/08 10:45
     **/
    void calInternalDataLikeExternal(String yearMonth);

    /**
     * 根据年月计算点外费用
     *
     * @param yearMonth 年月
     * @return void
     * @author jiangyin
     * @date 2023/1/12 10:53
     */
    void calExternalData(String yearMonth);

    /**
     * 查询分子公司预算预测数据（分子公司活动规划用）
     *
     * @param subComBudgetForecastDto
     * @return java.util.List<com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastVo>
     * @author huojia
     * @date 2022/11/30 14:25
     **/
    List<SubComBudgetForecastVo> listByConditions(SubComBudgetForecastDto subComBudgetForecastDto);

    /**
     * 占用预算预测
     *
     * @param subComBudgetForecastDtoList
     * @author huojia
     * @date 2022/12/1 16:11
     **/
    void operationBudgetForecast(List<SubComBudgetForecastDetailDto> subComBudgetForecastDtoList);

    /**
     * 根据组织编码+年月取分子公司税金及附加
     *
     * @param subComBudgetForecastVo
     * @return
     */
    BigDecimal queryTaxAndAddition(SubComBudgetForecastVo subComBudgetForecastVo);

    /**
     * 清空预算预测数据
     *
     * @param budgetForecastCodeList
     * @author huojia
     * @date 2022/12/26 22:42
     **/
    void clearByCode(List<String> budgetForecastCodeList);

    void generateBudgetForecastForActivityPlan(List<ActivityPlanItemDto> activityPlanItemList);

    /**
     * 合计
     *
     * @param dto
     * @return {@link BigDecimal}
     */
    SubComBudgetForecastVo summationBudgetAmount(SubComBudgetForecastDto dto);

    /**
     * 导入
     *
     * @param importList
     * @author huojia
     * @date 2023/2/18 15:50
     **/
    void importSave(List<SubComBudgetForecastDto> importList);

    /**
     * 分子活动规划关闭退还分子预算预测
     *
     * @param forecastDto
     * @param returnAutoAmount
     * @param returnInternalAmount
     * @param returnOffAmount
     */
    default void releaseAmount(SubComBudgetForecastDto forecastDto, BigDecimal returnAutoAmount, BigDecimal returnInternalAmount, BigDecimal returnOffAmount) {

    }

    /**
     * 根据分子公司预算预测编码集合获取信息
     *
     * @param codes
     * @return
     */
    List<SubComBudgetForecastVo> findListByCodes(List<String> codes);

    /**
     * 根据分子公司预算编码集合获取信息
     *
     * @param codes
     * @return
     */
    List<SubComBudgetForecastVo> findListByBudgetItemCodes(List<String> codes);
    /**
     * 变更承接金额
     *
     * @param dto
     * @param wholeUndertakeAmt 变更的完全承接金额，增加传正数，扣减传负数
     * @param partUndertakeAmt  变更的部分承接金额，增加传正数，扣减传负数
     */
    void changeUndertakeAmt(SubComBudgetForecastDto dto, BigDecimal wholeUndertakeAmt, BigDecimal partUndertakeAmt);

    /**
     * 根据id查询
     *
     * @param id
     * @return
     */
    SubComBudgetForecastVo findById(String id);

    boolean lock(List<String> budgetForecastCodes, TimeUnit timeUnit, int time);

    void unLock(List<String> budgetForecastCodes);

    /**
     * 调整
     *
     * @param dto
     */
    void adjust(SubComBudgetForecastAdjustDto dto);

    /**
     * 分子预算预测提交审批
     *
     * @param dto
     * @return
     */
    String adjustSubmit(SubComBudgetForecastAdjustDto dto);

    /**
     * 冻结/解冻
     *
     * @param dto
     */
    void unOrFreeze(SubComBudgetForecastOperateDto dto, String operationType);

    /**
     * 变更
     *
     * @param dto
     */
    void change(SubComBudgetForecastOperateDto dto);

    /**
     * 变更提交审批
     *
     * @param dto
     * @return
     */
    String changeSubmit(SubComBudgetForecastOperateDto dto);

    /**
     * 条件查询预算
     *
     * @param subComBudgetForecastDto
     * @return
     */
    List<SubComBudgetForecastVo> findListByConditions(SubComBudgetForecastDto subComBudgetForecastDto);

    /**
     * 通过预算预测编码查询分子预算预测
     *
     * @param budgetForecastCodeList
     * @return
     */
    List<SubComBudgetForecastVo> listByBudgetForecastCodeList(List<String> budgetForecastCodeList);


    /**
     * 审批中查看调整数据
     *
     * @param processNo
     * @return com.biz.crm.tpm.business.budget.forecast.sdk.vo.SubComBudgetForecastAdjustVo
     * @author huojia
     * @date 2022/12/23 14:20
     **/
    SubComBudgetForecastMainAdjustVo adjustQuery(String processNo);

    /**
     * 审批中查看变更数据
     *
     * @param processNo
     * @return
     */
    SubComBudgetForecastChangeVo changeQuery(String processNo);

    /**
     * 根据拼接key查询预算预测（分子月度预算）
     * @param onlykeys 拼接key列表
     * @return List<SubComBudgetForecastVo>
     */
    List<SubComBudgetForecastVo> listByOnlyKeys(List<String> onlykeys);

    /**
     * 单条预算预测提交审批（只是手动录入的）
     *
     * @param dto 实体对象
     * @return 结果
     */
    void submitApproval(SubComBudgetApprovalDto dto);

    /**
     * 根据唯一组合键获取
     *
     * @param uniqueKeys
     * @return
     */
    List<SubComBudgetForecastVo> findListByUniqueKeys(List<String> uniqueKeys);

    /**
     * 删除数据
     *
     * @param ids 主键结合
     * @return 删除结果
     */
    void delete(List<String> ids);

    /**
     * 根据流程编码查询变更详情
     *
     * @param processNo 流程编码
     * @return SubComBudgetForecastProcessVo
     */
    SubComBudgetForecastProcessVo findChangeDetailByProcessNo(String processNo);

    /**
     * 通过项目预算编码获取分子预算预测
     * @param budgetItemCodes
     * @return
     */
    List<SubComBudgetForecastVo> findByBudgetItemCodes(List<String> budgetItemCodes);

    /**
     * 更新剩余金额
     * @param
     * @return
     */
    void updateForecastRemainderAmount(String id, BigDecimal amount);

    Page<SubComBudgetForecastVo> findSubBudgetForecastByConditions(Pageable pageable, SubComBudgetForecastDto selectDto);

    /**
     * 自投超额提示
     * @return
     */
    default List<String> excessPrompt(Integer excessPromptTotal){
        return Lists.newArrayList();
    }

    /**
     * 分子利润监控报表汇总
     * @param pageable
     * @param dto
     * @return
     */
    Page<SubComBudgetForecastVo> findListByProfitMonitor(Pageable pageable, SubComBudgetForecastDto dto);

    /**
     * 分子利润监控报表自投费用汇总
     * @param records
     * @return
     */
    List<SubComAutoDetailVo> findAutoDetailSummary(List<SubComBudgetForecastVo> records);

    Page<SubComBudgetForecastVo> findBySonCompanyBudgetWarn(Pageable pageable, List<String> yearMonthList, String orgCode, String saleCompanyCode, String channelCode, String saleGroupCode, String customerCode, String budgetItemCode);

}
