package com.biz.crm.tpm.business.budget.forecast.sdk.vo;

import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelImport;
import com.biz.crm.common.ie.sdk.excel.vo.CrmExcelVo;
import lombok.Data;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月28日 17:19
 */
@Data
@CrmExcelImport(startRow = 1)
public class BudgetForecastImportsVo extends CrmExcelVo {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @CrmExcelColumn(value = "业态[数据字典:mdm_business_format]", order = 0)
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @CrmExcelColumn(value = "业务单元[数据字典:mdm_business_unit]", order = 1)
    private String businessUnitCode;

    /**
     * 预算项目编码
     */
    @CrmExcelColumn(value = "预算项目编码", order = 2)
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @CrmExcelColumn(value = "预算项目名称", order = 3)
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @CrmExcelColumn(value = "预算项目层级[数据字典:tpm_budget_item_level]", order = 4)
    private String budgetItemLevelCode;

    /**
     * 年份
     */
    @CrmExcelColumn(value = "年份", order = 5)
    private String yearLy;

    /**
     * 费用归类[数据字典:tpm_fee_classify]
     */
    @CrmExcelColumn(value = "费用归类[数据字典:tpm_fee_classify]", order = 6)
    private String feeClassifyCode;

    /**
     * 预测类型[数据字典:tpm_forecast_type]
     */
    @CrmExcelColumn(value = "预测类型[数据字典:tpm_forecast_type]", order = 7)
    private String forecastTypeCode;

    /**
     * 销售组织编码
     */
    @CrmExcelColumn(value = "销售组织编码", order = 8)
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @CrmExcelColumn(value = "销售组织名称", order = 9)
    private String salesOrgName;

    /**
     * 一月份
     */
    @CrmExcelColumn(value = "一月份", order = 10)
    private String januaryNumStr;

    /**
     * 二月份
     */
    @CrmExcelColumn(value = "二月份", order = 11)
    private String februaryNumStr;

    /**
     * 三月份
     */
    @CrmExcelColumn(value = "三月份", order = 12)
    private String marchNumStr;

    /**
     * 四月份
     */
    @CrmExcelColumn(value = "四月份", order = 13)
    private String aprilNumStr;

    /**
     * 五月份
     */
    @CrmExcelColumn(value = "五月份", order = 14)
    private String mayNumStr;

    /**
     * 六月份
     */
    @CrmExcelColumn(value = "六月份", order = 15)
    private String juneNumStr;

    /**
     * 七月份
     */
    @CrmExcelColumn(value = "七月份", order = 16)
    private String julyNumStr;

    /**
     * 八月份
     */
    @CrmExcelColumn(value = "八月份", order = 17)
    private String augustNumStr;

    /**
     * 九月份
     */
    @CrmExcelColumn(value = "九月份", order = 18)
    private String septemberNumStr;

    /**
     * 十月份
     */
    @CrmExcelColumn(value = "十月份", order = 19)
    private String octoberNumStr;

    /**
     * 十一月份
     */
    @CrmExcelColumn(value = "十一月份", order = 20)
    private String novemberNumStr;

    /**
     * 十二月份
     */
    @CrmExcelColumn(value = "十二月份", order = 21)
    private String decemberNumStr;

    /*其他类型字段*/

    /**
     * 一月份
     */
    private BigDecimal januaryNum;

    /**
     * 二月份
     */
    private BigDecimal februaryNum;

    /**
     * 三月份
     */
    private BigDecimal marchNum;

    /**
     * 四月份
     */
    private BigDecimal aprilNum;

    /**
     * 五月份
     */
    private BigDecimal mayNum;

    /**
     * 六月份
     */
    private BigDecimal juneNum;

    /**
     * 七月份
     */
    private BigDecimal julyNum;

    /**
     * 八月份
     */
    private BigDecimal augustNum;

    /**
     * 九月份
     */
    private BigDecimal septemberNum;

    /**
     * 十月份
     */
    private BigDecimal octoberNum;

    /**
     * 十一月份
     */
    private BigDecimal novemberNum;

    /**
     * 十二月份
     */
    private BigDecimal decemberNum;
}
