package com.biz.crm.tpm.business.budget.forecast.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;

/**
 * @author huojia
 * @date 2022年10月27日 15:26
 */
@ApiModel(value = "BudgetForecastVo", description = "TPM-预算预测")
@Getter
@Setter
public class BudgetForecastVo extends TenantFlagOpVo {

    /**
     * 业态[数据字典:mdm_business_format]
     */
    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]", notes = "")
    private String businessFormatCode;

    /**
     * 业务单元[数据字典:mdm_business_unit]
     */
    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]", notes = "")
    private String businessUnitCode;


    /**
     * 预算项目编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    private String budgetItemName;

    /**
     * 预算项目层级[数据字典:tpm_budget_item_level]
     */
    @ApiModelProperty(value = "预算项目层级[数据字典:tpm_budget_item_level]", notes = "")
    private String budgetItemLevelCode;

    /**
     * 年份
     */
    @ApiModelProperty(value = "年份", notes = "")
    private String yearLy;

    /**
     * 费用归类[数据字典:tpm_fee_classify]
     */
    @ApiModelProperty(value = "费用归类[数据字典:tpm_fee_classify]", notes = "")
    private String feeClassifyCode;

    /**
     * 预测类型[数据字典:tpm_forecast_type]
     */
    @ApiModelProperty(value = "预测类型[数据字典:tpm_forecast_type]", notes = "")
    private String forecastTypeCode;

    /**
     * 销售组织编码
     */
    @ApiModelProperty(value = "销售组织编码", notes = "")
    private String salesOrgCode;

    /**
     * 销售组织名称
     */
    @ApiModelProperty(value = "销售组织名称", notes = "")
    private String salesOrgName;

    /**
     * 一月份
     */
    @ApiModelProperty("一月份")
    private BigDecimal januaryNum;

    /**
     * 二月份
     */
    @ApiModelProperty("二月份")
    private BigDecimal februaryNum;

    /**
     * 三月份
     */
    @ApiModelProperty("三月份")
    private BigDecimal marchNum;

    /**
     * 四月份
     */
    @ApiModelProperty("四月份")
    private BigDecimal aprilNum;

    /**
     * 五月份
     */
    @ApiModelProperty("五月份")
    private BigDecimal mayNum;

    /**
     * 六月份
     */
    @ApiModelProperty("六月份")
    private BigDecimal juneNum;

    /**
     * 七月份
     */
    @ApiModelProperty("七月份")
    private BigDecimal julyNum;

    /**
     * 八月份
     */
    @ApiModelProperty("八月份")
    private BigDecimal augustNum;

    /**
     * 九月份
     */
    @ApiModelProperty("九月份")
    private BigDecimal septemberNum;

    /**
     * 十月份
     */
    @ApiModelProperty("十月份")
    private BigDecimal octoberNum;

    /**
     * 十一月份
     */
    @ApiModelProperty("十一月份")
    private BigDecimal novemberNum;

    /**
     * 十二月份
     */
    @ApiModelProperty("十二月份")
    private BigDecimal decemberNum;

}
