package com.biz.crm.tpm.business.budget.forecast.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author huojia
 * @date 2022年10月31日 15:38
 */
@ApiModel(value = "BudgetForecastVo", description = "TPM-分子公司预算预测明细")
@Data
public class SubComAutoDetailVo extends TenantFlagOpVo {

    @ApiModelProperty("orgName")
    private String orgName;

    @ApiModelProperty("yearMonthLy")
    private String yearMonthLy;


    /**
     * 销售公司代码
     */
    @ApiModelProperty(name = "salesCompanyCode", value = "销售公司代码", notes = "销售公司代码")
    private String salesCompanyCode;


    /**
     * 分子公司自投核准金额
     */
    @ApiModelProperty(value = "分子公司自投核准金额")
    private BigDecimal approvedAmount;

    /**
     * 分子公司预算预测编码
     */
    @ApiModelProperty(value = "分子公司预算预测编码")
    private String budgetForecastCode;

    /**
     * 理论收入
     */
    @ApiModelProperty("理论收入")
    private BigDecimal theoryIncome;

    /**
     * 理论成本
     */
    @ApiModelProperty("理论成本")
    private BigDecimal theoryCost;

    /**
     * 理论毛利
     */
    @ApiModelProperty("理论毛利")
    private BigDecimal theoryProfit;

    /**
     * 固定支出
     */
    @ApiModelProperty("固定支出")
    private List<SubComFixedPayDetailVo> fixedPayDetailList;

    /**
     * 固定支出小计
     */
    @ApiModelProperty("固定支出小计")
    private BigDecimal fixedPayTotal;

    /**
     * 利润目标
     */
    @ApiModelProperty("利润目标")
    private BigDecimal profitGoal;

    /**
     * 考核扣款
     */
    @ApiModelProperty("考核扣款")
    private BigDecimal assessDeduction;

    /**
     * 税金及附加
     */
    @ApiModelProperty("税金及附加")
    private BigDecimal taxAmount;

    /**
     * 自投费用
     */
    @ApiModelProperty("自投费用")
    private BigDecimal autoAmount;

    @ApiModelProperty("年度折前销售额")
    private BigDecimal yearBeforeDiscountSales;

    @ApiModelProperty("月度折前销售额")
    private BigDecimal monthBeforeDiscountSales;

    @ApiModelProperty("年度VS月度折前销售额")
    private BigDecimal diffBeforeDiscountSales;

    @ApiModelProperty("年度折后销售额")
    private BigDecimal yearAfterDiscountSales;

    @ApiModelProperty("月度折后销售额")
    private BigDecimal monthAfterDiscountSales;

    @ApiModelProperty("年度VS月度折后销售额")
    private BigDecimal diffAfterDiscountSales;

    @ApiModelProperty("年度自投")
    private BigDecimal yearAutoAmount;

    @ApiModelProperty("月度自投")
    private BigDecimal monthAutoAmount;

    @ApiModelProperty("年度VS月度自投")
    private BigDecimal diffAutoAmount;

    @ApiModelProperty("年度折前费销比")
    private BigDecimal yearBeforeDiscountRatio;
    private String yearBeforeDiscountRatioStr;

    @ApiModelProperty("月度折前费销比")
    private BigDecimal monthBeforeDiscountRatio;
    private String monthBeforeDiscountRatioStr;

    @ApiModelProperty("年度VS月度折前费销比")
    private BigDecimal diffBeforeDiscountRatio;
    private String diffBeforeDiscountRatioStr;

    @ApiModelProperty("年度折后费销比")
    private BigDecimal yearAfterDiscountRatio;
    private String yearAfterDiscountRatioStr;

    @ApiModelProperty("月度折后费销比")
    private BigDecimal monthAfterDiscountRatio;
    private String monthAfterDiscountRatioStr;

    @ApiModelProperty("年度VS月度折后费销比")
    private BigDecimal diffAfterDiscountRatio;
    private String diffAfterDiscountRatioStr;


    @ApiModelProperty(value = "业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    @ApiModelProperty(value = "业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;
    @ApiModelProperty(value = "组织编码")
    private String orgCode;

    @ApiModelProperty(name = "预算金额类型")
    private String budgetAmountType;

    @ApiModelProperty("费用金额")
    private BigDecimal feeAmount;
}
