package com.biz.crm.tpm.business.daily.sales.data.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.daily.sales.data.feign.feign.internal.SapDaySalesVoFeignImpl;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 *
 * @author hd
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = SapDaySalesVoFeignImpl.class)
public interface SapDaySalesVoFeign {

    /**
     * 条件查询数据
     *
     * @param ds
     * @return
     */
    @ApiOperation("条件查询参数")
    @PostMapping("/v1/tpmSapDaySales")
    Result<?> pullDataList(@RequestParam @ApiParam(name = "ds", value = "ds(例：20230206)") String ds);
}
