package com.biz.crm.tpm.business.daily.sales.data.local.consumer;

import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.util.RocketMqUtil;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.daily.sales.data.sdk.constant.DailySalesDataConstant;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import lombok.extern.slf4j.Slf4j;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 同步105数据
 *
 * @author hdy
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = RocketMqUtil.ORDER + "${rocketmq.topic}" + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag定义在 RocketMQConstant.CRM_MQ_TAG 内统一维护
        */
        selectorExpression = DailySalesDataConstant.TPM_SAP_SALES_MESSAGE_TAG,
        /**
         * 相同分组下 consumer 可自动负载均衡
        */
        consumerGroup = DailySalesDataConstant.TPM_SAP_SALES_MESSAGE_TAG + "${rocketmq.environment}",
        /**
         * 默认集群消费
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.ORDERLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class TpmSapDaySalesConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private TpmSapDaySalesService tpmSapDaySalesService;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("=====>    KMS通知TPM同步105数据消息接收成功    <=====");
        try {
            String msgBody = message.getMsgBody();
            log.info("=====>    KMS通知TPM同步105信息[{}]    <=====", message.getMsgBody());
            log.info("=====>    KMS通知TPM同步105数据消息接,消息开始执行    <=====");
            this.tpmSapDaySalesService.synchronizationSap(msgBody);
            log.info("=====>    KMS通知TPM同步105数据消息,消息执行结束    <=====");
        } catch (Exception e) {
            log.error("", e);
        }
        return "消费成功";
    }
}