package com.biz.crm.tpm.business.daily.sales.data.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.daily.sales.data.sdk.dto.TpmSapDaySalesExamineCircularSearchDto;
import com.biz.crm.tpm.business.daily.sales.data.sdk.service.TpmSapDaySalesService;
import com.biz.crm.tpm.business.daily.sales.data.sdk.vo.TpmSapDaySalesExamineCircularSearchVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 *
 * @author hd
 */
@RestController
@RequestMapping("/v1/tpmSapDaySales")
@Slf4j
@Api(tags = "TMP-分子公司日销售")
public class TpmSapDaySalesController {
    @Autowired(required = false)
    private TpmSapDaySalesService tpmSapDaySalesService;

    /**
     * 通过时间分区拉取数据
     *
     * @param ds 时间分区
     * @return 数据
     */
    @ApiOperation(value = "通过时间分区拉取数据")
    @PostMapping()
    public Result<?> pullDataList(@RequestParam @ApiParam(name = "ds", value = "ds(例：20230206)") String ds) {
        try {
            tpmSapDaySalesService.synchronizationSap(ds);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "考勤通报管理查询分摊数据")
    @GetMapping("findExamineCircularDataList")
    public Result<List<TpmSapDaySalesExamineCircularSearchVo>> findExamineCircularDataList(
            @ApiParam(name = "TpmSapDaySalesExamineCircularSearchDto", value = "考勤通报管理查询分摊数据条件") TpmSapDaySalesExamineCircularSearchDto dto,
            @ApiParam(name = "cacheKey", value = "缓存key(UUID+业务单元编码)") @RequestParam String cacheKey) {
        try {
            return Result.ok(this.tpmSapDaySalesService.findExamineCircularDataList(dto, cacheKey));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }
}
