package com.biz.crm.tpm.business.daily.sales.data.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * @author hd
 * @create 2023-02-06 15:01:38
 */
@ApiModel(value = "TpmDailySalesData", description = "TPM- 日销售数据")
@TableName("tpm_daily_sales_data")
@Getter
@Setter
@Entity(name = "tpm_daily_sales_data")
@org.hibernate.annotations.Table(appliesTo = "tpm_daily_sales_data", comment = "TPM-日销售数据")
@Table(name = "tpm_daily_sales_data", indexes = {
        @Index(name = "tpm_daily_sales_data_index1", columnList = "verify_code"),
        @Index(name = "tpm_daily_sales_data_index2", columnList = "ds"),
        @Index(name = "tpm_daily_sales_data_index3", columnList = "customer_code"),
        @Index(name = "tpm_daily_sales_data_index4", columnList = "material_code"),
        @Index(name = "tpm_daily_sales_data_index5", columnList = "sale_vou_type_code"),
        @Index(name = "tpm_daily_sales_data_index6", columnList = "voucher_date"),
        @Index(name = "tpm_daily_sales_data_index7", columnList = "year_month_ly"),
})
public class TpmDailySalesDataEntity extends TenantFlagOpEntity {
    @ApiModelProperty("客户端")
    @Column(name = "client", length = 32, columnDefinition = "varchar(32) COMMENT '客户端'")
    private String client;

    @ApiModelProperty("发票号")
    @Column(name = "invoice_number", length = 32, columnDefinition = "varchar(32) COMMENT '发票号'")
    private String invoiceNumber;

    @ApiModelProperty("发票行项目号")
    @Column(name = "invoicing_items", length = 64, columnDefinition = "varchar(64) COMMENT '发票行项目号'")
    private String invoicingItems;

    @ApiModelProperty("售达方代码")
    @Column(name = "dealer_code", length = 64, columnDefinition = "varchar(64) COMMENT '售达方代码'")
    private String dealerCode;

    @ApiModelProperty("售达方名称")
    @Column(name = "dealer_name", length = 64, columnDefinition = "varchar(64) COMMENT '售达方名称'")
    private String dealerName;

    @ApiModelProperty("售达方简称")
    @Column(name = "dealer_short_name", length = 32, columnDefinition = "varchar(32) COMMENT '售达方简称'")
    private String dealerShortName;

    @ApiModelProperty("送达方代码")
    @Column(name = "service_code", length = 64, columnDefinition = "varchar(64) COMMENT '送达方代码'")
    private String serviceCode;

    @ApiModelProperty("送达方名称")
    @Column(name = "service_name", length = 64, columnDefinition = "varchar(64) COMMENT '送达方名称'")
    private String serviceName;

    @ApiModelProperty("销售机构ERP代码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = "varchar(64) COMMENT '销售机构ERP代码'")
    private String salesOrgCode;

    @ApiModelProperty("发票类型")
    @Column(name = "invoice_type", length = 32, columnDefinition = "varchar(32) COMMENT '发票类型'")
    private String invoiceType;

    @ApiModelProperty("产品组代码")
    @Column(name = "spart_code", length = 64, columnDefinition = "varchar(64) COMMENT '产品组代码'")
    private String spartCode;

    @ApiModelProperty("分销渠道代码")
    @Column(name = "channel_code", length = 64, columnDefinition = "varchar(64) COMMENT '分销渠道代码'")
    private String channelCode;

    @ApiModelProperty("销售大区ERP编码")
    @Column(name = "sale_office_code", length = 64, columnDefinition = "varchar(64) COMMENT '销售大区ERP编码'")
    private String saleOfficeCode;

    @ApiModelProperty("销售大区编码")
    @Column(name = "tpm_sales_org_code", length = 64, columnDefinition = "varchar(64) COMMENT '销售大区编码'")
    private String tpmSalesOrgCode;

    @ApiModelProperty("销售大区名称")
    @Column(name = "sale_office_name", length = 64, columnDefinition = "varchar(64) COMMENT '销售大区名称'")
    private String saleOfficeName;

    @ApiModelProperty("销售组ERP代码")
    @Column(name = "sales_code", length = 64, columnDefinition = "varchar(64) COMMENT '销售组ERP代码'")
    private String salesCode;

    @ApiModelProperty("销售组编码")
    @Column(name = "sales_group_code", length = 64, columnDefinition = "varchar(64) COMMENT '销售组编码'")
    private String salesGroupCode;

    @ApiModelProperty("销售组名称")
    @Column(name = "sales_group_name", length = 255, columnDefinition = "varchar(255) COMMENT '销售组名称'")
    private String salesGroupName;

    @ApiModelProperty("物料代码")
    @Column(name = "material_code", length = 64, columnDefinition = "varchar(64) COMMENT '物料代码'")
    private String materialCode;

    @ApiModelProperty("物料描述")
    @Column(name = "material", length = 64, columnDefinition = "varchar(64) COMMENT '物料描述'")
    private String material;

    @ApiModelProperty("客户ABC等级")
    @Column(name = "dealer_level", length = 32, columnDefinition = "varchar(32) COMMENT '客户ABC等级'")
    private String dealerLevel;

    @ApiModelProperty("客户组代码")
    @Column(name = "dealers_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户组代码'")
    private String dealersCode;

    @ApiModelProperty("销售凭证")
    @Column(name = "sale_voucher", length = 64, columnDefinition = "varchar(64) COMMENT '销售凭证'")
    private String saleVoucher;

    @ApiModelProperty("凭证日期")
    @Column(name = "voucher_date", length = 32, columnDefinition = "varchar(32) COMMENT '凭证日期'")
    private String voucherDate;

    @ApiModelProperty("创建日期")
    @Column(name = "created_data_date", length = 32, columnDefinition = "varchar(32) COMMENT '创建数据日期'")
    private String createdDataDate;

    @ApiModelProperty("品牌描述")
    @Column(name = "brand", length = 64, columnDefinition = "varchar(64) COMMENT '品牌描述'")
    private String brand;

    @ApiModelProperty("城市")
    @Column(name = "city", length = 64, columnDefinition = "varchar(64) COMMENT '城市'")
    private String city;

    @ApiModelProperty("发货工厂代码")
    @Column(name = "shipping_factory_code", length = 64, columnDefinition = "varchar(64) COMMENT '发货工厂代码'")
    private String shippingFactoryCode;
    @ApiModelProperty("发货工厂描述")
    @Column(name = "delivery_factory", length = 64, columnDefinition = "varchar(64) COMMENT '发货工厂描述'")
    private String deliveryFactory;
    @ApiModelProperty("运输方式描述")
    @Column(name = "transport_mode", length = 64, columnDefinition = "varchar(64) COMMENT '运输方式描述'")
    private String transportMode;
    @ApiModelProperty("生产工厂代码")
    @Column(name = "prod_factory_code", length = 64, columnDefinition = "varchar(64) COMMENT '生产工厂代码'")
    private String prodFactoryCode;
    @ApiModelProperty("生产工厂名称")
    @Column(name = "prod_factory_name", length = 64, columnDefinition = "varchar(64) COMMENT '生产工厂名称'")
    private String prodFactoryName;

    @ApiModelProperty("单价")
    @Column(name = "price", length = 32, columnDefinition = "varchar(32) COMMENT '单价'")
    private String price;

    @ApiModelProperty("固定折扣率")
    @Column(name = "fix_discount_rate", length = 32, columnDefinition = "varchar(32) COMMENT '固定折扣率'")
    private String fixDiscountRate;

    @ApiModelProperty("折扣单价")
    @Column(name = "discount_price", length = 32, columnDefinition = "varchar(32) COMMENT '折扣单价'")
    private String discountPrice;

    @ApiModelProperty("浮动折扣率")
    @Column(name = "float_discount_rate", length = 32, columnDefinition = "varchar(32) COMMENT '浮动折扣率'")
    private String floatDiscountRate;

    @ApiModelProperty("订单数量")
    @Column(name = "order_num", columnDefinition = "decimal(20,4) COMMENT '订单数量'")
    private BigDecimal orderNum;

    @ApiModelProperty("买/赠品率")
    @Column(name = "gift_rate", length = 32, columnDefinition = "varchar(32) COMMENT '买/赠品率'")
    private String giftRate;

    @ApiModelProperty("折扣金额")
    @Column(name = "discount_amt", columnDefinition = "decimal(20,4) COMMENT '折扣金额'")
    private BigDecimal discountAmt;

    @ApiModelProperty("折后总金额")
    @Column(name = "after_discount_amt", columnDefinition = "decimal(20,4) COMMENT '折后总金额'")
    private BigDecimal afterDiscountAmt;
    @ApiModelProperty("物料总净重量")
    @Column(name = "material_net_weight", length = 32, columnDefinition = "varchar(32) COMMENT '物料总净重量'")
    private String materialNetWeight;

    @ApiModelProperty("销售订单总净重量")
    @Column(name = "order_net_weight", columnDefinition = "decimal(20,4) COMMENT '销售订单总净重量'")
    private BigDecimal orderNetWeight;
    @ApiModelProperty("重量单位")
    @Column(name = "weight", length = 32, columnDefinition = "varchar(32) COMMENT '重量单位'")
    private String weight;

    @ApiModelProperty("折前总金额")
    @Column(name = "before_discount_amt", columnDefinition = "decimal(20,4) COMMENT '折前总金额'")
    private BigDecimal beforeDiscountAmt;
    @ApiModelProperty("货损数量")
    @Column(name = "damage_num", columnDefinition = "decimal(20,4) COMMENT '货损数量'")
    private BigDecimal damageNum;

    @ApiModelProperty("货损金额")
    @Column(name = "damage_amt", columnDefinition = "decimal(20,4) COMMENT '货损金额'")
    private BigDecimal damageAmt;
    @ApiModelProperty("赠品数量")
    @Column(name = "gift_num", columnDefinition = "decimal(20,4) COMMENT '赠品数量'")
    private BigDecimal giftNum;
    @ApiModelProperty("赠品金额")
    @Column(name = "gift_amt", columnDefinition = "decimal(20,4) COMMENT '赠品金额'")
    private BigDecimal giftAmt;
    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "decimal(20,4) COMMENT '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty("浮动搭赠比")
    @Column(name = "float_match_gift_ratio", length = 32, columnDefinition = "varchar(32) COMMENT '浮动搭赠比'")
    private String floatMatchGiftRatio;
    @ApiModelProperty("仓储地点描述")
    @Column(name = "goods", length = 64, columnDefinition = "varchar(64) COMMENT '仓储地点描述'")
    private String goods;
    @ApiModelProperty("物料定价组代码")
    @Column(name = "material_price_code", length = 64, columnDefinition = "varchar(64) COMMENT '物料定价组代码'")
    private String materialPriceCode;
    @ApiModelProperty("物料定价组描述")
    @Column(name = "material_price", length = 64, columnDefinition = "varchar(64) COMMENT '物料定价组描述'")
    private String materialPrice;
    @ApiModelProperty("地区代码")
    @Column(name = "area_code", length = 64, columnDefinition = "varchar(64) COMMENT '地区代码'")
    private String areaCode;
    @ApiModelProperty("地区描述")
    @Column(name = "area", length = 64, columnDefinition = "varchar(64) COMMENT '地区描述'")
    private String area;
    @ApiModelProperty("创建人代码")
    @Column(name = "creator_code", length = 64, columnDefinition = "varchar(64) COMMENT '创建人代码'")
    private String creatorCode;
    @ApiModelProperty("创建人姓名")
    @Column(name = "creator", length = 64, columnDefinition = "varchar(64) COMMENT '创建人姓名'")
    private String creator;
    @ApiModelProperty("销售凭证类型代码")
    @Column(name = "sale_vou_type_code", length = 64, columnDefinition = "varchar(64) COMMENT '销售凭证类型代码'")
    private String saleVouTypeCode;
    @ApiModelProperty("销售凭证类型描述")
    @Column(name = "sale_vou_type", length = 64, columnDefinition = "varchar(64) COMMENT '销售凭证类型描述'")
    private String saleVouType;
    @ApiModelProperty("分类1")
    @Column(name = "sort1", length = 32, columnDefinition = "varchar(32) COMMENT '分类1'")
    private String sort1;
    @ApiModelProperty("分类2")
    @Column(name = "sort2", length = 32, columnDefinition = "varchar(32) COMMENT '分类2'")
    private String sort2;
    @ApiModelProperty("分类3")
    @Column(name = "sort3", length = 32, columnDefinition = "varchar(32) COMMENT '分类3'")
    private String sort3;
    @ApiModelProperty("分类4")
    @Column(name = "sort4", length = 32, columnDefinition = "varchar(32) COMMENT '分类4'")
    private String sort4;
    @ApiModelProperty("分类5")
    @Column(name = "sort5", length = 32, columnDefinition = "varchar(32) COMMENT '分类5'")
    private String sort5;
    @ApiModelProperty("分类6")
    @Column(name = "sort6", length = 32, columnDefinition = "varchar(32) COMMENT '分类6'")
    private String sort6;
    @ApiModelProperty("分类7")
    @Column(name = "sort7", length = 32, columnDefinition = "varchar(32) COMMENT '分类7'")
    private String sort7;
    @ApiModelProperty("分类8")
    @Column(name = "sort8", length = 32, columnDefinition = "varchar(32) COMMENT '分类8'")
    private String sort8;
    @ApiModelProperty("分类9")
    @Column(name = "sort9", length = 32, columnDefinition = "varchar(32) COMMENT '分类9'")
    private String sort9;
    @ApiModelProperty("分类10")
    @Column(name = "sort10", length = 32, columnDefinition = "varchar(32) COMMENT '分类10'")
    private String sort10;

    @ApiModelProperty("费用池折扣金额")
    @Column(name = "expense_pool_discount_amt", columnDefinition = "decimal(20,4) COMMENT '费用池折扣金额'")
    private BigDecimal expensePoolDiscountAmt;
    @ApiModelProperty("非费用池折扣金额")
    @Column(name = "noexpense_pool_discount_amt", columnDefinition = "decimal(20,4) COMMENT '非费用池折扣金额'")
    private BigDecimal noexpensePoolDiscountAmt;
    @ApiModelProperty("结算单价")
    @Column(name = "accounts_price", columnDefinition = "decimal(20,4) COMMENT '结算单价'")
    private BigDecimal accountsPrice;
    @ApiModelProperty("结算金额")
    @Column(name = "accounts_amt", columnDefinition = "decimal(20,4) COMMENT '结算金额'")
    private BigDecimal accountsAmt;

    @ApiModelProperty("记录日期")
    @Column(name = "record_date", length = 64, columnDefinition = "varchar(32) COMMENT '记录日期'")
    private String recordDate;
    @ApiModelProperty("时间分区")
    @Column(name = "ds", length = 64, columnDefinition = "varchar(64) COMMENT '时间分区'")
    private String ds;

    /**
     * 校验字段
     */
    @Column(name = "verify_code", length = 64, columnDefinition = "varchar(64) COMMENT '校验字段(发票号+发票行号)'")
    private String verifyCode;

    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '客户编码'")
    private String customerCode;

    @ApiModelProperty("销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("年月")
    @Column(name = "year_month_ly", length = 10, nullable = true, columnDefinition = "varchar(10) COMMENT '年月'")
    private String yearMonthLy;

}
